/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.ioc.spring;

import br.com.caelum.vraptor.ioc.ApplicationScoped;
import br.com.caelum.vraptor.ioc.StereotypeHandler;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ApplicationScoped
public class StereotypedBeansRegistrar
implements ApplicationListener<ApplicationEvent> {
    private static final Logger LOGGER = LoggerFactory.getLogger(StereotypedBeansRegistrar.class);
    private final List<StereotypeHandler> stereotypeHandlers;

    public StereotypedBeansRegistrar(List<StereotypeHandler> stereotypeHandlers) {
        this.stereotypeHandlers = stereotypeHandlers;
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ContextRefreshedEvent) {
            this.handleRefresh(((ContextRefreshedEvent)event).getApplicationContext());
        }
    }

    private void handleRefresh(ApplicationContext beanFactory) {
        String[] beanDefinitionNames;
        for (String name : beanDefinitionNames = beanFactory.getBeanDefinitionNames()) {
            Class beanType = beanFactory.getType(name);
            LOGGER.debug("scanning {} for bean definition {}", (Object)beanType, (Object)name);
            if (beanType == null) {
                LOGGER.info("null type for bean {}", (Object)name);
                continue;
            }
            for (StereotypeHandler handler : this.stereotypeHandlers) {
                LOGGER.trace("scanning {} with {}", (Object)beanType, (Object)handler);
                if (!beanType.isAnnotationPresent(handler.stereotype())) continue;
                handler.handle(beanType);
            }
        }
    }
}

