/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.ioc.pico;

import br.com.caelum.vraptor.core.RequestInfo;
import br.com.caelum.vraptor.ioc.AbstractComponentRegistry;
import br.com.caelum.vraptor.ioc.ApplicationScoped;
import br.com.caelum.vraptor.ioc.ComponentFactory;
import br.com.caelum.vraptor.ioc.ComponentFactoryIntrospector;
import br.com.caelum.vraptor.ioc.PrototypeScoped;
import br.com.caelum.vraptor.ioc.SessionScoped;
import br.com.caelum.vraptor.ioc.pico.ComponentFactoryRegistry;
import br.com.caelum.vraptor.ioc.pico.PicoBasedContainer;
import br.com.caelum.vraptor.ioc.pico.PicoComponentAdapter;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpSession;
import org.picocontainer.Characteristics;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.ComponentMonitor;
import org.picocontainer.DefaultPicoContainer;
import org.picocontainer.LifecycleStrategy;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.Parameter;
import org.picocontainer.PicoContainer;
import org.picocontainer.behaviors.Caching;
import org.picocontainer.lifecycle.JavaEE5LifecycleStrategy;
import org.picocontainer.monitors.NullComponentMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PicoComponentRegistry
extends AbstractComponentRegistry {
    public static final String CONTAINER_SESSION_KEY = PicoComponentRegistry.class.getName() + ".session";
    private static final Logger logger = LoggerFactory.getLogger(PicoComponentRegistry.class);
    private final Map<Class<?>, Class<?>> applicationScoped = new HashMap();
    private final Map<Class<?>, Class<?>> sessionScoped = new HashMap();
    private final Map<Class<?>, Class<?>> requestScoped = new HashMap();
    private final Map<Class<?>, Class<?>> prototypeScoped = new HashMap();
    private MutablePicoContainer appContainer;
    private boolean initialized = false;
    private final ComponentFactoryRegistry componentFactoryRegistry;

    public PicoComponentRegistry(MutablePicoContainer container, ComponentFactoryRegistry componentFactoryRegistry) {
        this.appContainer = container;
        this.componentFactoryRegistry = componentFactoryRegistry;
    }

    MutablePicoContainer makeChildContainer() {
        this.appContainer = this.appContainer.makeChildContainer();
        return this.appContainer;
    }

    @Override
    public void register(Class<?> requiredType, Class<?> type) {
        logger.debug("Registering " + requiredType.getName() + " with " + type.getName());
        if (this.alreadyRegistered(requiredType)) {
            logger.debug("Overriding interface " + requiredType.getName() + " with " + type.getName());
        }
        this.registerOnScope(requiredType, type);
        this.registerComponentFactory(requiredType, type);
        this.checkInitialization(requiredType, type);
    }

    private void registerOnScope(Class<?> requiredType, Class<?> type) {
        if (type.isAnnotationPresent(ApplicationScoped.class)) {
            logger.debug("Registering " + type.getName() + " as an application component");
            this.applicationScoped.put(requiredType, type);
        } else if (type.isAnnotationPresent(SessionScoped.class)) {
            logger.debug("Registering " + type.getName() + " as a session component");
            this.sessionScoped.put(requiredType, type);
        } else if (type.isAnnotationPresent(PrototypeScoped.class)) {
            logger.debug("Registering " + type.getName() + " as a prototype component");
            this.prototypeScoped.put(requiredType, type);
        } else {
            logger.debug("Registering " + type.getName() + " as a request component");
            this.requestScoped.put(requiredType, type);
        }
    }

    private void checkInitialization(Class<?> requiredType, Class<?> type) {
        if (type.isAnnotationPresent(ApplicationScoped.class) && this.initialized) {
            logger.warn("VRaptor was already initialized, the contexts were created but you are registering a component.This is nasty. The original component might already be in use.Avoid doing it: " + requiredType.getName());
            this.appContainer.addComponent(requiredType, type, new Parameter[0]);
            if (this.isComponentFactory(requiredType, type)) {
                Class<?> targetType = new ComponentFactoryIntrospector().targetTypeForComponentFactory(type);
                this.appContainer.addAdapter((ComponentAdapter)new PicoComponentAdapter(targetType, type));
            }
        }
    }

    private void registerComponentFactory(Class<?> requiredType, Class<?> type) {
        if (this.isComponentFactory(requiredType, type)) {
            this.componentFactoryRegistry.register(type);
        }
    }

    private boolean isComponentFactory(Class<?> requiredType, Class<?> type) {
        return ComponentFactory.class.isAssignableFrom(type) && !requiredType.equals(ComponentFactory.class);
    }

    public void init() {
        logger.info("Initializing VRaptor IoC Container implementation based on PicoContainer");
        for (Map.Entry<Class<?>, Class<?>> entry : this.applicationScoped.entrySet()) {
            logger.debug("Initializing application scope with key: " + entry.getKey() + ", for component: " + entry.getValue());
            this.appContainer.addComponent(entry.getKey(), entry.getValue(), new Parameter[0]);
        }
        this.registerComponentFactories(this.appContainer, this.componentFactoryRegistry.getApplicationMap());
        logger.debug("Session components to initialize: " + this.sessionScoped.keySet());
        logger.debug("Requets components to initialize: " + this.requestScoped.keySet());
        this.initialized = true;
    }

    PicoBasedContainer provideRequestContainer(RequestInfo request) {
        MutablePicoContainer parentContainer;
        if (this.sessionScoped.isEmpty()) {
            logger.debug("There's no @SessionScoped component, so skipping session container creation");
            parentContainer = this.appContainer;
        } else {
            parentContainer = this.getSessionContainer(request);
        }
        logger.debug("Request components are {}", this.requestScoped);
        DefaultPicoContainer requestContainer = new DefaultPicoContainer((org.picocontainer.ComponentFactory)new Caching(), (LifecycleStrategy)new JavaEE5LifecycleStrategy((ComponentMonitor)new NullComponentMonitor()), (PicoContainer)parentContainer);
        requestContainer.addComponent(HttpSession.class, (Object)request.getRequest().getSession(), new Parameter[0]);
        for (Map.Entry<Class<?>, Class<?>> entry : this.requestScoped.entrySet()) {
            requestContainer.addComponent(entry.getKey(), entry.getValue(), new Parameter[0]);
        }
        for (Map.Entry<Class<?>, Class<?>> entry : this.prototypeScoped.entrySet()) {
            requestContainer.as(new Properties[]{Characteristics.NO_CACHE}).addComponent(entry.getKey(), entry.getValue(), new Parameter[0]);
        }
        requestContainer.addComponent((Object)request).addComponent((Object)request.getRequest()).addComponent((Object)request.getResponse());
        this.registerComponentFactories((MutablePicoContainer)requestContainer, this.componentFactoryRegistry.getRequestMap());
        return new PicoBasedContainer((MutablePicoContainer)requestContainer);
    }

    private MutablePicoContainer getSessionContainer(RequestInfo request) {
        HttpSession session = request.getRequest().getSession();
        MutablePicoContainer sessionScope = (MutablePicoContainer)session.getAttribute(CONTAINER_SESSION_KEY);
        if (sessionScope == null) {
            sessionScope = this.createSessionContainer(session);
        }
        return sessionScope;
    }

    private boolean alreadyRegistered(Class<?> interfaceType) {
        for (Map scope : new Map[]{this.applicationScoped, this.sessionScoped, this.requestScoped, this.prototypeScoped}) {
            if (!scope.containsKey(interfaceType)) continue;
            scope.remove(interfaceType);
            return true;
        }
        return false;
    }

    private MutablePicoContainer createSessionContainer(HttpSession session) {
        DefaultPicoContainer sessionContainer = new DefaultPicoContainer((org.picocontainer.ComponentFactory)new Caching(), (LifecycleStrategy)new JavaEE5LifecycleStrategy((ComponentMonitor)new NullComponentMonitor()), (PicoContainer)this.appContainer);
        sessionContainer.addComponent(HttpSession.class, (Object)session, new Parameter[0]);
        session.setAttribute(CONTAINER_SESSION_KEY, (Object)sessionContainer);
        logger.debug("Session components are {}", this.sessionScoped);
        for (Map.Entry<Class<?>, Class<?>> entry : this.sessionScoped.entrySet()) {
            sessionContainer.addComponent(entry.getKey(), entry.getValue(), new Parameter[0]);
        }
        this.registerComponentFactories((MutablePicoContainer)sessionContainer, this.componentFactoryRegistry.getSessionMap());
        sessionContainer.start();
        return sessionContainer;
    }

    private void registerComponentFactories(MutablePicoContainer container, Map<Class<?>, Class<? extends ComponentFactory>> componentFactoryMap) {
        for (Class<?> targetType : componentFactoryMap.keySet()) {
            container.addAdapter((ComponentAdapter)new PicoComponentAdapter(targetType, componentFactoryMap.get(targetType)));
        }
    }

    public Collection<Class<?>> getAllRegisteredApplicationScopedComponents() {
        HashSet components = new HashSet();
        components.addAll(this.applicationScoped.values());
        components.addAll(this.sessionScoped.values());
        components.addAll(this.requestScoped.values());
        components.addAll(this.prototypeScoped.values());
        return components;
    }
}

