/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.ioc.pico;

import br.com.caelum.vraptor.ioc.ComponentFactory;
import java.lang.reflect.Type;
import org.picocontainer.PicoCompositionException;
import org.picocontainer.PicoContainer;
import org.picocontainer.adapters.AbstractAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PicoComponentAdapter
extends AbstractAdapter {
    private static final Logger logger = LoggerFactory.getLogger(PicoComponentAdapter.class);
    private final Class<?> targetType;
    private final Class<? extends ComponentFactory> componentFactoryClass;

    public PicoComponentAdapter(Class<?> targetType, Class<? extends ComponentFactory> componentFactoryClass) {
        super(targetType, targetType);
        logger.debug("New adapter for {}", (Object)componentFactoryClass.getName());
        this.targetType = targetType;
        this.componentFactoryClass = componentFactoryClass;
    }

    public Object getComponentInstance(PicoContainer pico, Type type) throws PicoCompositionException {
        logger.debug("Providing {} instance via {}", (Object)this.targetType.getName(), (Object)this.componentFactoryClass.getName());
        ComponentFactory componentFactory = (ComponentFactory)pico.getComponent(this.componentFactoryClass);
        return componentFactory.getInstance();
    }

    public String getDescriptor() {
        return "Adapter for " + this.targetType.getName();
    }

    public void verify(PicoContainer pico) throws PicoCompositionException {
    }
}

