/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.ioc.guice;

import br.com.caelum.vraptor.ComponentRegistry;
import br.com.caelum.vraptor.Converter;
import br.com.caelum.vraptor.core.BaseComponents;
import br.com.caelum.vraptor.core.RequestInfo;
import br.com.caelum.vraptor.http.MutableRequest;
import br.com.caelum.vraptor.http.MutableResponse;
import br.com.caelum.vraptor.ioc.ApplicationScoped;
import br.com.caelum.vraptor.ioc.Container;
import br.com.caelum.vraptor.ioc.PrototypeScoped;
import br.com.caelum.vraptor.ioc.RequestScoped;
import br.com.caelum.vraptor.ioc.SessionScoped;
import br.com.caelum.vraptor.ioc.StereotypeHandler;
import br.com.caelum.vraptor.ioc.guice.GuiceComponentRegistry;
import br.com.caelum.vraptor.ioc.guice.GuiceProvider;
import br.com.caelum.vraptor.ioc.guice.ScopeLifecycleListener;
import br.com.caelum.vraptor.ioc.spring.VRaptorRequestHolder;
import br.com.caelum.vraptor.serialization.xstream.XStreamJSONSerialization;
import br.com.caelum.vraptor.serialization.xstream.XStreamXMLSerialization;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Provider;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import com.google.inject.matcher.AbstractMatcher;
import com.google.inject.matcher.Matcher;
import com.google.inject.matcher.Matchers;
import com.google.inject.multibindings.Multibinder;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VRaptorAbstractModule
extends AbstractModule {
    private static final Logger logger = LoggerFactory.getLogger(VRaptorAbstractModule.class);
    private final ServletContext context;
    private final Container container;

    public VRaptorAbstractModule(ServletContext context, Container container) {
        this.context = context;
        this.container = container;
    }

    protected void configure() {
        this.bindScope(RequestScoped.class, GuiceProvider.REQUEST);
        this.bindScope(SessionScoped.class, GuiceProvider.SESSION);
        this.bindScope(ApplicationScoped.class, Scopes.SINGLETON);
        this.bindScope(PrototypeScoped.class, Scopes.NO_SCOPE);
        Matcher<TypeLiteral<?>> isApplication = VRaptorAbstractModule.type((Matcher<? super Class>)Matchers.annotatedWith(ApplicationScoped.class));
        Matcher<TypeLiteral<?>> isSession = VRaptorAbstractModule.type((Matcher<? super Class>)Matchers.annotatedWith(SessionScoped.class));
        this.bindListener(isApplication, new ScopeLifecycleListener(GuiceProvider.APPLICATION));
        this.bindListener(isSession, new ScopeLifecycleListener(GuiceProvider.SESSION));
        this.bindListener(Matchers.not(isApplication).and(Matchers.not(isSession)), new ScopeLifecycleListener(GuiceProvider.REQUEST));
        this.requestInfoBindings();
        this.bind(Container.class).toInstance((Object)this.container);
        GuiceComponentRegistry registry = new GuiceComponentRegistry(this.binder());
        this.bind(ComponentRegistry.class).toInstance((Object)registry);
        registry.registerInScope(BaseComponents.getApplicationScoped(), GuiceProvider.APPLICATION);
        registry.registerInScope(BaseComponents.getPrototypeScoped(), Scopes.NO_SCOPE);
        registry.registerInScope(BaseComponents.getRequestScoped(), GuiceProvider.REQUEST);
        for (Class<? extends Converter<?>> clazz : BaseComponents.getBundledConverters()) {
            registry.register((Class)clazz, (Class)clazz);
        }
        for (Class<? extends StereotypeHandler> handler : BaseComponents.getStereotypeHandlers()) {
            registry.register((Class)handler, (Class)handler);
            Multibinder stereotypeHandlers = Multibinder.newSetBinder((Binder)this.binder(), StereotypeHandler.class);
            stereotypeHandlers.addBinding().to(handler);
        }
        for (Map.Entry entry : BaseComponents.getCachedComponents().entrySet()) {
            registry.register((Class)entry.getKey(), (Class)entry.getValue());
        }
        registry.register((Class)XStreamXMLSerialization.class, (Class)XStreamXMLSerialization.class);
        registry.register((Class)XStreamJSONSerialization.class, (Class)XStreamJSONSerialization.class);
    }

    private void requestInfoBindings() {
        this.bind(MutableRequest.class).toProvider((Provider)new Provider<MutableRequest>(){

            public MutableRequest get() {
                return VRaptorRequestHolder.currentRequest().getRequest();
            }
        });
        this.bind(RequestInfo.class).toProvider((Provider)new Provider<RequestInfo>(){

            public RequestInfo get() {
                return VRaptorRequestHolder.currentRequest();
            }
        });
        this.bind(HttpSession.class).toProvider((Provider)new Provider<HttpSession>(){

            public HttpSession get() {
                return VRaptorRequestHolder.currentRequest().getRequest().getSession();
            }
        });
        this.bind(MutableResponse.class).toProvider((Provider)new Provider<MutableResponse>(){

            public MutableResponse get() {
                return VRaptorRequestHolder.currentRequest().getResponse();
            }
        });
        this.bind(HttpServletResponse.class).to(MutableResponse.class);
        this.bind(HttpServletRequest.class).to(MutableRequest.class);
        this.bind(ServletContext.class).toInstance((Object)this.context);
    }

    static Matcher<TypeLiteral<?>> type(final Matcher<? super Class> matcher) {
        return new AbstractMatcher<TypeLiteral<?>>(){

            public boolean matches(TypeLiteral<?> literal) {
                return matcher.matches((Object)literal.getRawType());
            }
        };
    }
}

