/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.ioc.guice;

import br.com.caelum.vraptor.ioc.guice.AbstractScope;
import br.com.caelum.vraptor.ioc.guice.LifecycleListener;
import br.com.caelum.vraptor.ioc.guice.LifecycleScope;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import com.google.inject.Inject;
import com.google.inject.Provider;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionCustomScope
extends AbstractScope
implements LifecycleScope {
    private static final Logger logger = LoggerFactory.getLogger(SessionCustomScope.class);
    private Multimap<String, LifecycleListener> listeners = LinkedListMultimap.create();
    private Provider<HttpSession> provider;

    @Inject
    public void setProvider(Provider<HttpSession> provider) {
        this.provider = provider;
    }

    @Override
    AbstractScope.ScopeHolder getHolder() {
        return new AbstractScope.ScopeHolder(){

            public void setAttribute(String name, Object value) {
                ((HttpSession)SessionCustomScope.this.provider.get()).setAttribute(name, value);
            }

            public Object getAttribute(String name) {
                return ((HttpSession)SessionCustomScope.this.provider.get()).getAttribute(name);
            }
        };
    }

    @Override
    String getScopeName() {
        return "SESSION";
    }

    @Override
    public void registerDestroyListener(LifecycleListener listener) {
        this.listeners.put((Object)((HttpSession)this.provider.get()).getId(), (Object)listener);
    }

    public void start(HttpSession session) {
        this.stop(session);
    }

    public void stop(HttpSession session) {
        for (LifecycleListener listener : this.listeners.removeAll((Object)session.getId())) {
            this.stop(listener);
        }
    }

    public void stopAll() {
        for (LifecycleListener listener : this.listeners.values()) {
            this.stop(listener);
        }
    }

    private void stop(LifecycleListener listener) {
        try {
            listener.onEvent();
        }
        catch (Exception e) {
            logger.warn("Error while invoking PreDestroy", (Throwable)e);
        }
    }
}

