/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.ioc.guice;

import br.com.caelum.vraptor.ioc.guice.LifecycleListener;
import br.com.caelum.vraptor.ioc.guice.LifecycleScope;
import com.google.inject.TypeLiteral;
import com.google.inject.spi.InjectionListener;
import com.google.inject.spi.TypeEncounter;
import com.google.inject.spi.TypeListener;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import net.vidageek.mirror.dsl.Mirror;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ScopeLifecycleListener
implements TypeListener {
    private static final Logger logger = LoggerFactory.getLogger(ScopeLifecycleListener.class);
    private final LifecycleScope scope;

    public ScopeLifecycleListener(LifecycleScope scope) {
        this.scope = scope;
    }

    public <I> void hear(TypeLiteral<I> literal, TypeEncounter<I> encounter) {
        ArrayList<Method> constructs = new ArrayList<Method>();
        ArrayList<Method> destroys = new ArrayList<Method>();
        this.extractLifecycleMethods(literal, constructs, destroys);
        logger.debug("Registering lifecycle listeners for {}", literal);
        if (!constructs.isEmpty() || !destroys.isEmpty()) {
            encounter.register((InjectionListener)new LifecycleExecutor(constructs, destroys));
        }
    }

    private <I> void extractLifecycleMethods(TypeLiteral<I> literal, List<Method> constructs, List<Method> destroys) {
        for (Method method : new Mirror().on(literal.getRawType()).reflectAll().methods()) {
            if (method.isAnnotationPresent(PostConstruct.class)) {
                constructs.add(method);
            }
            if (!method.isAnnotationPresent(PreDestroy.class)) continue;
            destroys.add(method);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class LifecycleExecutor
    implements InjectionListener {
        private final List<Method> destroys;
        private final List<Method> constructs;

        private LifecycleExecutor(List<Method> constructs, List<Method> destroys) {
            this.destroys = destroys;
            this.constructs = constructs;
        }

        public void afterInjection(final Object instance) {
            for (Method method : this.constructs) {
                new Mirror().on(instance).invoke().method(method).withoutArgs();
            }
            ScopeLifecycleListener.this.scope.registerDestroyListener(new LifecycleListener(){

                public void onEvent() {
                    for (Method method : LifecycleExecutor.this.destroys) {
                        new Mirror().on(instance).invoke().method(method).withoutArgs();
                    }
                }
            });
        }
    }
}

