/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.ioc.guice;

import br.com.caelum.vraptor.ComponentRegistry;
import br.com.caelum.vraptor.ioc.Cacheable;
import br.com.caelum.vraptor.ioc.ComponentFactory;
import br.com.caelum.vraptor.ioc.ComponentFactoryIntrospector;
import br.com.caelum.vraptor.ioc.guice.AllImplementationsProvider;
import br.com.caelum.vraptor.ioc.guice.ComponentFactoryProviderAdapter;
import br.com.caelum.vraptor.ioc.guice.GuiceProvider;
import br.com.caelum.vraptor.ioc.guice.VRaptorAbstractModule;
import com.google.inject.Binder;
import com.google.inject.Scope;
import com.google.inject.ScopeAnnotation;
import com.google.inject.TypeLiteral;
import com.google.inject.binder.ScopedBindingBuilder;
import com.google.inject.matcher.Matcher;
import com.google.inject.matcher.Matchers;
import com.google.inject.spi.TypeEncounter;
import com.google.inject.spi.TypeListener;
import com.google.inject.util.Types;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GuiceComponentRegistry
implements ComponentRegistry {
    private static final Logger logger = LoggerFactory.getLogger(GuiceComponentRegistry.class);
    private final Binder binder;
    private final Set<Class<?>> boundClasses = new HashSet();
    private final Set<Class<?>> listTypes = new HashSet();

    public GuiceComponentRegistry(Binder binder) {
        this.binder = binder;
    }

    public void register(Class requiredType, Class componentType) {
        this.boundClasses.add(requiredType);
        logger.debug("Binding {} to {}", (Object)requiredType, (Object)componentType);
        ScopedBindingBuilder binding = this.bindToConstructor(requiredType, componentType);
        if (this.defaultScope(componentType)) {
            binding.in((Scope)GuiceProvider.REQUEST);
        }
        this.registerFactory(componentType);
    }

    private boolean defaultScope(Class componentType) {
        for (Annotation annotation : componentType.getAnnotations()) {
            if (!annotation.annotationType().isAnnotationPresent(ScopeAnnotation.class)) continue;
            return false;
        }
        return true;
    }

    public void deepRegister(Class componentType) {
        this.register(componentType, componentType);
        this.deepRegister(componentType, componentType);
    }

    private void deepRegister(Class required, Class component) {
        if (required == null || required.equals(Object.class)) {
            return;
        }
        if (this.boundClasses.add(required)) {
            logger.debug("Binding {} to {}", (Object)required, (Object)component);
            this.binder.bind(required).to(component);
        } else {
            logger.debug("Ignoring binding of {} to {}", (Object)required, (Object)component);
        }
        for (Class<?> c : required.getInterfaces()) {
            this.deepRegister(c, component);
        }
        this.deepRegister(required.getSuperclass(), component);
    }

    public void registerInScope(Map<Class, Class> classes, Scope scope) {
        for (Map.Entry<Class, Class> entry : classes.entrySet()) {
            this.bindToConstructor(entry.getKey(), entry.getValue()).in(scope);
            this.registerFactory(entry.getValue());
        }
    }

    private ScopedBindingBuilder bindToConstructor(Class requiredType, Class componentType) {
        if (componentType.isAnnotationPresent(Cacheable.class)) {
            return this.binder.bind(requiredType).annotatedWith(Cacheable.class).toConstructor(componentType.getDeclaredConstructors()[0]);
        }
        Constructor<?> constructor = componentType.getDeclaredConstructors()[0];
        for (Type type : constructor.getGenericParameterTypes()) {
            ParameterizedType ptype;
            if (!(type instanceof ParameterizedType) || !((ptype = (ParameterizedType)type).getRawType() instanceof Class) || !List.class.isAssignableFrom((Class)ptype.getRawType()) || !(ptype.getRawType() instanceof Class) || this.listTypes.contains(ptype.getActualTypeArguments()[0])) continue;
            this.listTypes.add((Class)ptype.getActualTypeArguments()[0]);
            this.registerListType((Class)ptype.getActualTypeArguments()[0], this.binder);
        }
        return this.binder.bind(requiredType).toConstructor(constructor);
    }

    private void registerFactory(Class componentType) {
        if (ComponentFactory.class.isAssignableFrom(componentType)) {
            Class<?> target = new ComponentFactoryIntrospector().targetTypeForComponentFactory(componentType);
            ParameterizedType adapterType = Types.newParameterizedType(ComponentFactoryProviderAdapter.class, (Type[])new Type[]{target});
            ParameterizedType factoryType = Types.newParameterizedType(ComponentFactory.class, (Type[])new Type[]{target});
            this.binder.bind(TypeLiteral.get((Type)factoryType)).to(componentType);
            this.binder.bind(target).toProvider(TypeLiteral.get((Type)adapterType));
        }
    }

    private <T> void registerListType(Class<T> type, Binder binder) {
        final AllImplementationsProvider provider = new AllImplementationsProvider();
        binder.bindListener(VRaptorAbstractModule.type((Matcher<? super Class>)Matchers.subclassesOf(type)), new TypeListener(){

            public void hear(TypeLiteral literal, TypeEncounter encounter) {
                provider.addType(literal.getRawType());
            }
        });
        binder.bind(TypeLiteral.get((Type)Types.listOf(type))).toProvider(provider);
        binder.requestInjection(provider);
    }
}

