/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.interceptor.multipart;

import br.com.caelum.vraptor.InterceptionException;
import br.com.caelum.vraptor.Intercepts;
import br.com.caelum.vraptor.Validator;
import br.com.caelum.vraptor.core.InterceptorStack;
import br.com.caelum.vraptor.http.InvalidParameterException;
import br.com.caelum.vraptor.http.MutableRequest;
import br.com.caelum.vraptor.interceptor.ResourceLookupInterceptor;
import br.com.caelum.vraptor.interceptor.multipart.DefaultUploadedFile;
import br.com.caelum.vraptor.interceptor.multipart.MultipartConfig;
import br.com.caelum.vraptor.interceptor.multipart.MultipartInterceptor;
import br.com.caelum.vraptor.interceptor.multipart.ServletFileUploadCreator;
import br.com.caelum.vraptor.ioc.RequestScoped;
import br.com.caelum.vraptor.resource.ResourceMethod;
import br.com.caelum.vraptor.validator.Validations;
import com.google.common.base.Strings;
import com.google.common.collect.LinkedListMultimap;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Intercepts(before={ResourceLookupInterceptor.class}, after={})
@RequestScoped
public class CommonsUploadMultipartInterceptor
implements MultipartInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(CommonsUploadMultipartInterceptor.class);
    private final HttpServletRequest request;
    private final MutableRequest parameters;
    private final MultipartConfig config;
    private final Validator validator;
    private final ServletFileUploadCreator fileUploadCreator;

    public CommonsUploadMultipartInterceptor(HttpServletRequest request, MutableRequest parameters, MultipartConfig cfg, Validator validator, ServletFileUploadCreator fileUploadCreator) {
        this.request = request;
        this.parameters = parameters;
        this.validator = validator;
        this.config = cfg;
        this.fileUploadCreator = fileUploadCreator;
    }

    public boolean accepts(ResourceMethod method) {
        return ServletFileUpload.isMultipartContent((HttpServletRequest)this.request);
    }

    public void intercept(InterceptorStack stack, ResourceMethod method, Object instance) throws InterceptionException {
        logger.info("Request contains multipart data. Try to parse with commons-upload.");
        FileItemFactory factory = this.createFactoryForDiskBasedFileItems(this.config.getDirectory());
        ServletFileUpload uploader = this.fileUploadCreator.create(factory);
        uploader.setSizeMax(this.config.getSizeLimit());
        try {
            List items = uploader.parseRequest(this.request);
            logger.debug("Found {} attributes in the multipart form submission. Parsing them.", (Object)items.size());
            LinkedListMultimap params = LinkedListMultimap.create();
            for (FileItem item : items) {
                String name = item.getFieldName();
                if (item.isFormField()) {
                    logger.debug("{} is a field", (Object)name);
                    params.put((Object)name, (Object)this.getValue(item));
                    continue;
                }
                if (this.isNotEmpty(item)) {
                    logger.debug("{} is a file", (Object)name);
                    this.processFile(item, name);
                    continue;
                }
                logger.debug("A file field was empty: {}", (Object)item.getFieldName());
            }
            for (String paramName : params.keySet()) {
                Collection paramValues = params.get((Object)paramName);
                this.parameters.setParameter(paramName, paramValues.toArray(new String[paramValues.size()]));
            }
        }
        catch (FileUploadBase.SizeLimitExceededException e) {
            this.reportSizeLimitExceeded(e);
        }
        catch (FileUploadException e) {
            logger.warn("There was some problem parsing this multipart request, or someone is not sending a RFC1867 compatible multipart request.", (Throwable)e);
        }
        stack.next(method, instance);
    }

    private boolean isNotEmpty(FileItem item) {
        return item.getName().length() > 0;
    }

    protected void reportSizeLimitExceeded(final FileUploadBase.SizeLimitExceededException e) {
        this.validator.checking(new Validations(){
            {
                this.that(false, "upload", "file.limit.exceeded", e.getActualSize(), e.getPermittedSize());
            }
        });
        logger.warn("The file size limit was exceeded.", (Throwable)e);
    }

    protected void processFile(FileItem item, String name) {
        try {
            DefaultUploadedFile upload = new DefaultUploadedFile(item.getInputStream(), item.getName(), item.getContentType());
            this.parameters.setParameter(name, name);
            this.request.setAttribute(name, (Object)upload);
            logger.debug("Uploaded file: {} with {}", (Object)name, (Object)upload);
        }
        catch (IOException e) {
            throw new InvalidParameterException("Cant parse uploaded file " + item.getName(), e);
        }
    }

    protected FileItemFactory createFactoryForDiskBasedFileItems(File temporaryDirectory) {
        DiskFileItemFactory factory = new DiskFileItemFactory();
        factory.setRepository(temporaryDirectory);
        logger.debug("Using repository {} for file upload", (Object)factory.getRepository());
        return factory;
    }

    private String getValue(FileItem item) {
        String encoding = this.request.getCharacterEncoding();
        if (!Strings.isNullOrEmpty((String)encoding)) {
            try {
                return item.getString(encoding);
            }
            catch (UnsupportedEncodingException e) {
                logger.warn("Request have an invalid encoding. Ignoring it");
            }
        }
        return item.getString();
    }
}

