/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.interceptor;

import br.com.caelum.vraptor.Intercepts;
import br.com.caelum.vraptor.interceptor.ExecuteMethodInterceptor;
import br.com.caelum.vraptor.interceptor.Graph;
import br.com.caelum.vraptor.interceptor.Interceptor;
import br.com.caelum.vraptor.interceptor.InterceptorRegistry;
import br.com.caelum.vraptor.interceptor.ResourceLookupInterceptor;
import br.com.caelum.vraptor.ioc.ApplicationScoped;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ApplicationScoped
public class TopologicalSortedInterceptorRegistry
implements InterceptorRegistry {
    private Graph<Class<? extends Interceptor>> set = new Graph();

    @Override
    public List<Class<? extends Interceptor>> all() {
        return this.set.topologicalOrder();
    }

    @Override
    public void register(Class<? extends Interceptor> ... interceptors) {
        for (Class<? extends Interceptor> interceptor : interceptors) {
            Intercepts intercepts = interceptor.getAnnotation(Intercepts.class);
            if (intercepts != null) {
                this.addEdges(interceptor, intercepts.before(), intercepts.after());
                continue;
            }
            this.addDefaultEdges(interceptor);
        }
    }

    private void addDefaultEdges(Class<? extends Interceptor> interceptor) {
        this.set.addEdge(interceptor, ExecuteMethodInterceptor.class);
        if (!interceptor.equals(ResourceLookupInterceptor.class)) {
            this.set.addEdge(ResourceLookupInterceptor.class, interceptor);
        }
    }

    private void addEdges(Class<? extends Interceptor> interceptor, Class<? extends Interceptor>[] before, Class<? extends Interceptor>[] after) {
        this.set.addEdges(interceptor, before);
        for (Class<? extends Interceptor> other : after) {
            this.set.addEdge(other, interceptor);
        }
    }
}

