/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.interceptor;

import br.com.caelum.vraptor.InterceptionException;
import br.com.caelum.vraptor.Intercepts;
import br.com.caelum.vraptor.core.InterceptorStack;
import br.com.caelum.vraptor.core.MethodInfo;
import br.com.caelum.vraptor.core.RequestInfo;
import br.com.caelum.vraptor.http.UrlToResourceTranslator;
import br.com.caelum.vraptor.http.route.MethodNotAllowedException;
import br.com.caelum.vraptor.http.route.ResourceNotFoundException;
import br.com.caelum.vraptor.interceptor.Interceptor;
import br.com.caelum.vraptor.resource.MethodNotAllowedHandler;
import br.com.caelum.vraptor.resource.ResourceMethod;
import br.com.caelum.vraptor.resource.ResourceNotFoundHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Intercepts(after={})
public class ResourceLookupInterceptor
implements Interceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResourceLookupInterceptor.class);
    private final UrlToResourceTranslator translator;
    private final MethodInfo methodInfo;
    private final RequestInfo requestInfo;
    private final ResourceNotFoundHandler resourceNotFoundHandler;
    private final MethodNotAllowedHandler methodNotAllowedHandler;

    public ResourceLookupInterceptor(UrlToResourceTranslator translator, MethodInfo methodInfo, ResourceNotFoundHandler resourceNotFoundHandler, MethodNotAllowedHandler methodNotAllowedHandler, RequestInfo requestInfo) {
        this.translator = translator;
        this.methodInfo = methodInfo;
        this.methodNotAllowedHandler = methodNotAllowedHandler;
        this.resourceNotFoundHandler = resourceNotFoundHandler;
        this.requestInfo = requestInfo;
    }

    public void intercept(InterceptorStack stack, ResourceMethod ignorableMethod, Object resourceInstance) throws InterceptionException {
        try {
            ResourceMethod method = this.translator.translate(this.requestInfo);
            this.methodInfo.setResourceMethod(method);
            stack.next(method, resourceInstance);
        }
        catch (ResourceNotFoundException e) {
            this.resourceNotFoundHandler.couldntFind(this.requestInfo);
        }
        catch (MethodNotAllowedException e) {
            LOGGER.debug(e.getMessage(), (Throwable)e);
            this.methodNotAllowedHandler.deny(this.requestInfo, e.getAllowedMethods());
        }
    }

    public boolean accepts(ResourceMethod method) {
        return true;
    }
}

