/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.interceptor;

import br.com.caelum.vraptor.InterceptionException;
import br.com.caelum.vraptor.Intercepts;
import br.com.caelum.vraptor.Lazy;
import br.com.caelum.vraptor.Validator;
import br.com.caelum.vraptor.core.InterceptorStack;
import br.com.caelum.vraptor.core.Localization;
import br.com.caelum.vraptor.core.MethodInfo;
import br.com.caelum.vraptor.http.MutableRequest;
import br.com.caelum.vraptor.http.ParametersProvider;
import br.com.caelum.vraptor.interceptor.Interceptor;
import br.com.caelum.vraptor.interceptor.ResourceLookupInterceptor;
import br.com.caelum.vraptor.resource.ResourceMethod;
import br.com.caelum.vraptor.validator.Message;
import br.com.caelum.vraptor.view.FlashScope;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Intercepts(after={ResourceLookupInterceptor.class})
@Lazy
public class ParametersInstantiatorInterceptor
implements Interceptor {
    private final ParametersProvider provider;
    private final MethodInfo parameters;
    private static final Logger logger = LoggerFactory.getLogger(ParametersInstantiatorInterceptor.class);
    private final Validator validator;
    private final Localization localization;
    private final List<Message> errors = new ArrayList<Message>();
    private final MutableRequest request;
    private final FlashScope flash;

    public ParametersInstantiatorInterceptor(ParametersProvider provider, MethodInfo parameters, Validator validator, Localization localization, MutableRequest request, FlashScope flash) {
        this.provider = provider;
        this.parameters = parameters;
        this.validator = validator;
        this.localization = localization;
        this.request = request;
        this.flash = flash;
    }

    public boolean accepts(ResourceMethod method) {
        return method.getMethod().getParameterTypes().length > 0;
    }

    public void intercept(InterceptorStack stack, ResourceMethod method, Object resourceInstance) throws InterceptionException {
        Enumeration names = this.request.getParameterNames();
        while (names.hasMoreElements()) {
            this.fixParameter((String)names.nextElement());
        }
        Object[] values = this.getParametersFor(method);
        this.validator.addAll(this.errors);
        if (!this.errors.isEmpty()) {
            logger.debug("There are conversion errors: {}", this.errors);
        }
        logger.debug("Parameter values for {} are {}", (Object)method, (Object)values);
        this.parameters.setParameters(values);
        stack.next(method, resourceInstance);
    }

    private void fixParameter(String name) {
        if (name.contains(".class.")) {
            throw new IllegalArgumentException("Bug Exploit Attempt with parameter: " + name + "!!!");
        }
        if (name.contains("[]")) {
            String[] values = this.request.getParameterValues(name);
            for (int i = 0; i < values.length; ++i) {
                this.request.setParameter(name.replace("[]", "[" + i + "]"), values[i]);
            }
        }
    }

    private Object[] getParametersFor(ResourceMethod method) {
        Object[] args = this.flash.consumeParameters(method);
        if (args == null) {
            return this.provider.getParametersFor(method, this.errors, this.localization.getBundle());
        }
        return args;
    }
}

