/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.http.route;

import br.com.caelum.vraptor.http.MutableRequest;
import br.com.caelum.vraptor.http.route.ParametersControl;
import br.com.caelum.vraptor.http.route.PatternBasedType;
import br.com.caelum.vraptor.http.route.Route;
import br.com.caelum.vraptor.resource.DefaultResourceClass;
import br.com.caelum.vraptor.resource.DefaultResourceMethod;
import br.com.caelum.vraptor.resource.HttpMethod;
import br.com.caelum.vraptor.resource.ResourceMethod;
import com.google.common.base.Objects;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.EnumSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class PatternBasedStrategy
implements Route {
    private final Logger logger = LoggerFactory.getLogger(PatternBasedStrategy.class);
    private final PatternBasedType type;
    private final PatternBasedType method;
    private final EnumSet<HttpMethod> methods;
    private final ParametersControl control;
    private final int priority;

    public PatternBasedStrategy(ParametersControl control, PatternBasedType type, PatternBasedType method, Set<HttpMethod> methods, int priority) {
        this.control = control;
        this.type = type;
        this.method = method;
        this.methods = methods.isEmpty() ? EnumSet.allOf(HttpMethod.class) : EnumSet.copyOf(methods);
        this.priority = priority;
    }

    @Override
    public boolean canHandle(Class<?> type, Method method) {
        return this.type.matches(type.getName()) && this.method.matches(method.getName());
    }

    @Override
    public ResourceMethod resourceMethod(MutableRequest request, String uri) {
        this.control.fillIntoRequest(uri, request);
        String webLogic = request.getParameter("webLogic");
        String webMethod = request.getParameter("webMethod");
        String typeName = this.type.apply("webLogic", webLogic);
        try {
            DefaultResourceClass resource = new DefaultResourceClass(Class.forName(typeName));
            Method resourceMethod = this.method(resource.getType(), this.method.apply("webMethod", webMethod));
            return new DefaultResourceMethod(resource, resourceMethod);
        }
        catch (ClassNotFoundException e) {
            this.logger.debug("Unable to find type " + typeName + " for strategy " + this);
            throw new IllegalStateException("You must call canHandle before calling this method");
        }
    }

    @Override
    public EnumSet<HttpMethod> allowedMethods() {
        return this.methods;
    }

    @Override
    public boolean canHandle(String uri) {
        return this.control.matches(uri);
    }

    private Method method(Class<?> type, String methodName) {
        Method[] methods;
        for (Method m : methods = type.getDeclaredMethods()) {
            if (!m.getName().equals(methodName) || !this.isEligible(m)) continue;
            return m;
        }
        if (type.getSuperclass().equals(Object.class)) {
            return null;
        }
        return this.method(type.getSuperclass(), methodName);
    }

    private boolean isEligible(Method m) {
        return Modifier.isPublic(m.getModifiers()) && !Modifier.isStatic(m.getModifiers());
    }

    @Override
    public String urlFor(Class<?> type, Method m, Object ... params) {
        return this.control.apply(new String[]{this.type.extract("webLogic", type.getName()), this.method.extract("webMethod", m.getName())});
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public String getOriginalUri() {
        return this.control.toString();
    }

    public String toString() {
        return String.format("[PatternBasedStrategy: %-50s %-50s %s]", this.type, this.method, this.methods.size() == HttpMethod.values().length ? "ALL" : this.methods);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.method == null ? 0 : this.method.hashCode());
        result = 31 * result + (this.methods == null ? 0 : this.methods.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PatternBasedStrategy other = (PatternBasedStrategy)obj;
        return Objects.equal((Object)this.method, (Object)other.method) && Objects.equal(this.methods, other.methods) && Objects.equal((Object)this.type, (Object)other.type);
    }
}

