/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.http.route;

import br.com.caelum.vraptor.core.Converters;
import br.com.caelum.vraptor.http.ParameterNameProvider;
import br.com.caelum.vraptor.http.route.DefaultParametersControl;
import br.com.caelum.vraptor.http.route.Evaluator;
import br.com.caelum.vraptor.http.route.FixedMethodStrategy;
import br.com.caelum.vraptor.http.route.IllegalRouteException;
import br.com.caelum.vraptor.http.route.NoStrategy;
import br.com.caelum.vraptor.http.route.ParametersControl;
import br.com.caelum.vraptor.http.route.PatternBasedStrategy;
import br.com.caelum.vraptor.http.route.PatternBasedType;
import br.com.caelum.vraptor.http.route.Route;
import br.com.caelum.vraptor.http.route.RouteBuilder;
import br.com.caelum.vraptor.http.route.TypeFinder;
import br.com.caelum.vraptor.proxy.MethodInvocation;
import br.com.caelum.vraptor.proxy.Proxifier;
import br.com.caelum.vraptor.proxy.SuperMethod;
import br.com.caelum.vraptor.resource.DefaultResourceMethod;
import br.com.caelum.vraptor.resource.HttpMethod;
import br.com.caelum.vraptor.resource.ResourceMethod;
import br.com.caelum.vraptor.util.StringUtils;
import br.com.caelum.vraptor.util.Stringnifier;
import com.google.common.base.Joiner;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultRouteBuilder
implements RouteBuilder {
    private final Set<HttpMethod> supportedMethods = EnumSet.noneOf(HttpMethod.class);
    private final Proxifier proxifier;
    private static final Logger logger = LoggerFactory.getLogger(DefaultRouteBuilder.class);
    private final String originalUri;
    private Route strategy = new NoStrategy();
    private int priority = Integer.MAX_VALUE;
    private final DefaultParameterControlBuilder builder;
    private final TypeFinder finder;
    private final Converters converters;
    private final ParameterNameProvider nameProvider;
    private final Evaluator evaluator;

    public DefaultRouteBuilder(Proxifier proxifier, TypeFinder finder, Converters converters, ParameterNameProvider nameProvider, Evaluator evaluator, String uri) {
        this.proxifier = proxifier;
        this.finder = finder;
        this.converters = converters;
        this.nameProvider = nameProvider;
        this.evaluator = evaluator;
        this.originalUri = uri;
        this.builder = new DefaultParameterControlBuilder();
    }

    @Override
    public DefaultParameterControlBuilder withParameter(String name) {
        return this.builder.withParameter(name);
    }

    @Override
    public <T> T is(final Class<T> type) {
        MethodInvocation handler = new MethodInvocation<T>(){

            @Override
            public Object intercept(Object proxy, Method method, Object[] args, SuperMethod superMethod) {
                boolean alreadySetTheStrategy;
                boolean bl = alreadySetTheStrategy = !DefaultRouteBuilder.this.strategy.getClass().equals(NoStrategy.class);
                if (alreadySetTheStrategy) {
                    return null;
                }
                DefaultRouteBuilder.this.is(type, method);
                return null;
            }
        };
        return this.proxifier.proxify(type, handler);
    }

    @Deprecated
    public void is(PatternBasedType type, PatternBasedType method) {
        this.strategy = new PatternBasedStrategy(this.builder.build(), type, method, this.supportedMethods, this.priority);
    }

    @Override
    public void is(Class<?> type, Method method) {
        this.addParametersInfo(method);
        ResourceMethod resourceMethod = DefaultResourceMethod.instanceFor(type, method);
        String[] parameterNames = this.nameProvider.parameterNamesFor(method);
        this.strategy = new FixedMethodStrategy(this.originalUri, resourceMethod, this.supportedMethods, this.builder.build(), this.priority, parameterNames);
        logger.info(String.format("%-50s%s -> %10s", this.originalUri, this.supportedMethods.isEmpty() ? "[ALL]" : this.supportedMethods, Stringnifier.simpleNameFor(method)));
    }

    private void addParametersInfo(Method method) {
        String[] parameters = StringUtils.extractParameters(this.originalUri);
        Map<String, Class<?>> types = this.finder.getParameterTypes(method, this.sanitize(parameters));
        for (Map.Entry<String, Class<?>> entry : types.entrySet()) {
            if (this.builder.parameters.containsKey(entry.getKey())) continue;
            this.builder.withParameter(entry.getKey()).ofType((Class)entry.getValue());
        }
        for (String parameter : parameters) {
            String[] split = parameter.split(":");
            if (split.length < 2 || this.builder.parameters.containsKey(parameter)) continue;
            this.builder.withParameter(parameter).matching(split[1]);
        }
    }

    private String[] sanitize(String[] parameters) {
        String[] sanitized = new String[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            sanitized[i] = parameters[i].replaceAll("(\\:.*|\\*)$", "");
        }
        return sanitized;
    }

    @Override
    public DefaultRouteBuilder with(HttpMethod method) {
        this.supportedMethods.add(method);
        return this;
    }

    @Override
    public DefaultRouteBuilder with(Set<HttpMethod> methods) {
        this.supportedMethods.addAll(methods);
        return this;
    }

    @Override
    public DefaultRouteBuilder withPriority(int priority) {
        this.priority = priority;
        return this;
    }

    @Override
    public Route build() {
        if (this.strategy instanceof NoStrategy) {
            throw new IllegalRouteException("You have created a route, but did not specify any method to be invoked: " + this.originalUri);
        }
        return this.strategy;
    }

    public String toString() {
        if (this.supportedMethods.isEmpty()) {
            return String.format("<< Route: %s => %s >>", this.originalUri, this.strategy.toString());
        }
        return String.format("<< Route: %s %s=> %s >>", this.originalUri, this.supportedMethods, this.strategy.toString());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class DefaultParameterControlBuilder
    implements RouteBuilder.ParameterControlBuilder {
        private final Map<String, String> parameters = new HashMap<String, String>();
        private String name;

        private DefaultParameterControlBuilder withParameter(String name) {
            this.name = name;
            return this;
        }

        @Override
        public DefaultRouteBuilder ofType(Class<?> type) {
            this.parameters.put(this.name, this.regexFor(type));
            return DefaultRouteBuilder.this;
        }

        private String regexFor(Class<?> type) {
            if (Arrays.asList(Integer.class, Long.class, Integer.TYPE, Long.TYPE, BigInteger.class, Short.class, Short.TYPE).contains(type)) {
                return "-?\\d+";
            }
            if (Arrays.asList(Character.TYPE, Character.class).contains(type)) {
                return ".";
            }
            if (Arrays.asList(Double.class, BigDecimal.class, Double.TYPE, Float.class, Float.TYPE).contains(type)) {
                return "-?\\d*\\.?\\d+";
            }
            if (Arrays.asList(Boolean.class, Boolean.TYPE).contains(type)) {
                return "true|false";
            }
            if (Enum.class.isAssignableFrom(type)) {
                return Joiner.on((String)"|").join((Object[])type.getEnumConstants());
            }
            return "[^/]+";
        }

        @Override
        public DefaultRouteBuilder matching(String regex) {
            this.parameters.put(this.name, regex);
            return DefaultRouteBuilder.this;
        }

        private ParametersControl build() {
            return new DefaultParametersControl(DefaultRouteBuilder.this.originalUri, this.parameters, DefaultRouteBuilder.this.converters, DefaultRouteBuilder.this.evaluator);
        }
    }
}

