/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.http.route;

import br.com.caelum.vraptor.TwoWayConverter;
import br.com.caelum.vraptor.core.Converters;
import br.com.caelum.vraptor.http.MutableRequest;
import br.com.caelum.vraptor.http.route.Evaluator;
import br.com.caelum.vraptor.http.route.ParametersControl;
import br.com.caelum.vraptor.util.StringUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultParametersControl
implements ParametersControl {
    private final Logger logger = LoggerFactory.getLogger(DefaultParametersControl.class);
    private final List<String> parameters = new ArrayList<String>();
    private final Pattern pattern;
    private final String originalPattern;
    private final Converters converters;
    private final Evaluator evaluator;

    public DefaultParametersControl(String originalPattern, Map<String, String> parameterPatterns, Converters converters, Evaluator evaluator) {
        this.originalPattern = originalPattern;
        this.converters = converters;
        this.pattern = this.compilePattern(originalPattern, parameterPatterns);
        this.evaluator = evaluator;
    }

    public DefaultParametersControl(String originalPattern, Converters converters, Evaluator evaluator) {
        this(originalPattern, Collections.emptyMap(), converters, evaluator);
    }

    private Pattern compilePattern(String originalPattern, Map<String, String> parameterPatterns) {
        HashMap<String, String> parameters = new HashMap<String, String>(parameterPatterns);
        Matcher matcher = Pattern.compile("\\{((?=[^\\{]+?[\\{])[^\\}]+?\\}|[^\\}]+?)\\}").matcher(originalPattern);
        while (matcher.find()) {
            String defaultPattern;
            String value = matcher.group(1);
            String string = value.matches("^[^:]+\\*$") ? ".*" : (defaultPattern = value.indexOf(":") >= 0 ? value.replaceAll("^[^\\:]+?:", "") : "[^/]*");
            if (!parameters.containsKey(value)) {
                parameters.put(value, defaultPattern);
            }
            this.parameters.add(value.replaceAll("(\\:.*|\\*)$", ""));
        }
        String patternUri = originalPattern;
        patternUri = patternUri.replaceAll("/\\*", "/.*");
        for (Map.Entry parameter : parameters.entrySet()) {
            patternUri = patternUri.replace("{" + (String)parameter.getKey() + "}", "(" + (String)parameter.getValue() + ")");
        }
        this.logger.debug("For " + originalPattern + " retrieved " + patternUri + " with " + parameters);
        return Pattern.compile(patternUri);
    }

    @Override
    public String fillUri(String[] paramNames, Object ... paramValues) {
        if (paramNames.length != paramValues.length) {
            throw new IllegalArgumentException("paramNames must have the same length as paramValues. Names: " + Arrays.toString(paramNames) + " Values: " + Arrays.toString(paramValues));
        }
        String[] splittedPatterns = StringUtils.extractParameters(this.originalPattern);
        String base = this.originalPattern;
        for (int i = 0; i < this.parameters.size(); ++i) {
            Class<?> type;
            String key = this.parameters.get(i);
            Object param = this.selectParam(key, paramNames, paramValues);
            Object result = this.evaluator.get(param, key);
            if (result != null && this.converters.existsTwoWayFor(type = result.getClass())) {
                TwoWayConverter<?> converter = this.converters.twoWayConverterFor(type);
                result = converter.convert(result);
            }
            base = base.replace("{" + splittedPatterns[i] + "}", result == null ? "" : result.toString());
        }
        return base.replaceAll("\\.\\*", "");
    }

    private Object selectParam(String key, String[] paramNames, Object[] paramValues) {
        for (int i = 0; i < paramNames.length; ++i) {
            if (!key.matches("^" + paramNames[i] + "(\\..*|$)")) continue;
            return paramValues[i];
        }
        return null;
    }

    @Override
    public boolean matches(String uri) {
        return this.pattern.matcher(uri).matches();
    }

    @Override
    public void fillIntoRequest(String uri, MutableRequest request) {
        Matcher m = this.pattern.matcher(uri);
        m.matches();
        for (int i = 1; i <= m.groupCount(); ++i) {
            String name = this.parameters.get(i - 1);
            try {
                request.setParameter(name, URLDecoder.decode(m.group(i), "UTF-8"));
                continue;
            }
            catch (UnsupportedEncodingException e) {
                this.logger.error("Error when decoding url parameters");
            }
        }
    }

    @Override
    public String apply(String[] values) {
        String regex = "\\{.*?\\}";
        String result = this.originalPattern;
        for (int i = 0; i < values.length; ++i) {
            result = result.replaceFirst(regex, values[i].replaceAll("\\$", "\\\\\\$"));
        }
        return result.toString();
    }
}

