/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.http;

import br.com.caelum.vraptor.http.DefaultParameterNameProvider;
import br.com.caelum.vraptor.http.ParameterNameProvider;
import br.com.caelum.vraptor.ioc.ApplicationScoped;
import br.com.caelum.vraptor.util.Stringnifier;
import com.thoughtworks.paranamer.AnnotationParanamer;
import com.thoughtworks.paranamer.BytecodeReadingParanamer;
import com.thoughtworks.paranamer.CachingParanamer;
import com.thoughtworks.paranamer.ParameterNamesNotFoundException;
import com.thoughtworks.paranamer.Paranamer;
import java.lang.reflect.AccessibleObject;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class ParanamerNameProvider
implements ParameterNameProvider {
    private final Paranamer info = new CachingParanamer((Paranamer)new AnnotationParanamer((Paranamer)new BytecodeReadingParanamer()));
    private static final Logger logger = LoggerFactory.getLogger(ParanamerNameProvider.class);

    public String[] parameterNamesFor(AccessibleObject method) {
        try {
            Object[] parameterNames = this.info.lookupParameterNames(method);
            if (logger.isDebugEnabled()) {
                logger.debug("Found parameter names with paranamer for " + Stringnifier.simpleNameFor(method) + " as " + Arrays.toString(parameterNames));
            }
            String[] defensiveCopy = new String[parameterNames.length];
            System.arraycopy(parameterNames, 0, defensiveCopy, 0, parameterNames.length);
            return defensiveCopy;
        }
        catch (ParameterNamesNotFoundException e) {
            throw new IllegalStateException("Paranamer were not able to find your parameter names for " + method + "You must compile your code with debug information (javac -g) or register another " + "name provider. Try to use " + DefaultParameterNameProvider.class.getName() + " instead.");
        }
    }
}

