/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.http;

import br.com.caelum.vraptor.core.RequestInfo;
import br.com.caelum.vraptor.http.MutableRequest;
import br.com.caelum.vraptor.http.UrlToResourceTranslator;
import br.com.caelum.vraptor.http.route.MethodNotAllowedException;
import br.com.caelum.vraptor.http.route.Router;
import br.com.caelum.vraptor.ioc.ApplicationScoped;
import br.com.caelum.vraptor.resource.HttpMethod;
import br.com.caelum.vraptor.resource.ResourceMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class DefaultResourceTranslator
implements UrlToResourceTranslator {
    private final Logger logger = LoggerFactory.getLogger(DefaultResourceTranslator.class);
    private final Router router;

    public DefaultResourceTranslator(Router router) {
        this.router = router;
    }

    public ResourceMethod translate(RequestInfo info) {
        HttpMethod method;
        MutableRequest request = info.getRequest();
        String resourceName = info.getRequestedUri();
        this.logger.debug("trying to access {}", (Object)resourceName);
        try {
            method = HttpMethod.of(request);
        }
        catch (IllegalArgumentException e) {
            throw new MethodNotAllowedException(this.router.allowedMethodsFor(resourceName), request.getMethod());
        }
        ResourceMethod resource = this.router.parse(resourceName, method, request);
        this.logger.debug("found resource {}", (Object)resource);
        return resource;
    }
}

