/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.core;

import br.com.caelum.vraptor.InterceptionException;
import br.com.caelum.vraptor.core.InterceptorHandler;
import br.com.caelum.vraptor.core.InterceptorStack;
import br.com.caelum.vraptor.interceptor.Interceptor;
import br.com.caelum.vraptor.ioc.Container;
import br.com.caelum.vraptor.resource.ResourceMethod;
import java.lang.reflect.Constructor;
import net.vidageek.mirror.dsl.Mirror;
import net.vidageek.mirror.exception.MirrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LazyInterceptorHandler
implements InterceptorHandler {
    private static final Logger logger = LoggerFactory.getLogger(LazyInterceptorHandler.class);
    private final Container container;
    private final Class<? extends Interceptor> type;
    private Interceptor acceptor;

    public LazyInterceptorHandler(Container container, Class<? extends Interceptor> type) {
        this.container = container;
        this.type = type;
    }

    @Override
    public void execute(InterceptorStack stack, ResourceMethod method, Object resourceInstance) throws InterceptionException {
        boolean accepts;
        try {
            accepts = this.getAcceptor().accepts(method);
        }
        catch (NullPointerException e) {
            throw new InterceptionException("StaticInterceptors should not use constructor parameters inside the accepts method", e);
        }
        if (accepts) {
            Interceptor interceptor = this.container.instanceFor(this.type);
            if (interceptor == null) {
                throw new InterceptionException("Unable to instantiate interceptor for " + this.type.getName() + ": the container returned null.");
            }
            logger.debug("Invoking interceptor {}", (Object)interceptor.getClass().getSimpleName());
            interceptor.intercept(stack, method, resourceInstance);
        } else {
            stack.next(method, resourceInstance);
        }
    }

    private Interceptor getAcceptor() {
        if (this.acceptor == null) {
            try {
                Constructor<?> constructor = this.type.getDeclaredConstructors()[0];
                int argsLength = constructor.getParameterTypes().length;
                this.acceptor = this.type.cast(new Mirror().on(this.type).invoke().constructor(constructor).withArgs(new Object[argsLength]));
            }
            catch (MirrorException e) {
                if (e.getCause() instanceof NullPointerException) {
                    throw new InterceptionException("StaticInterceptors should not use constructor parameters inside the constructor", e);
                }
                throw new InterceptionException(e);
            }
        }
        return this.acceptor;
    }

    public String toString() {
        return "LazyInterceptorHandler for " + this.type.getName();
    }
}

