/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.core;

import br.com.caelum.vraptor.core.Localization;
import br.com.caelum.vraptor.core.RequestInfo;
import br.com.caelum.vraptor.core.SafeResourceBundle;
import br.com.caelum.vraptor.ioc.RequestScoped;
import br.com.caelum.vraptor.util.EmptyBundle;
import com.google.common.base.Strings;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.jstl.core.Config;
import javax.servlet.jsp.jstl.fmt.LocalizationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequestScoped
public class JstlLocalization
implements Localization {
    private static final Logger logger = LoggerFactory.getLogger(JstlLocalization.class);
    private static final String DEFAULT_BUNDLE_NAME = "messages";
    private final RequestInfo request;
    private ResourceBundle bundle;

    public JstlLocalization(RequestInfo request) {
        this.request = request;
    }

    public ResourceBundle getBundle() {
        if (this.bundle == null) {
            this.initializeBundle();
        }
        return this.bundle;
    }

    private void initializeBundle() {
        Object bundle = this.findByKey("javax.servlet.jsp.jstl.fmt.localizationContext");
        ResourceBundle unsafe = this.extractUnsafeBundle(bundle);
        this.bundle = new SafeResourceBundle(unsafe);
    }

    private ResourceBundle extractUnsafeBundle(Object bundle) {
        if (bundle instanceof String || bundle == null) {
            String baseName = bundle == null ? DEFAULT_BUNDLE_NAME : bundle.toString();
            try {
                return ResourceBundle.getBundle(baseName, this.getLocale());
            }
            catch (MissingResourceException e) {
                logger.debug("couldn't find message bundle, creating an empty one");
                return new EmptyBundle();
            }
        }
        if (bundle instanceof LocalizationContext) {
            return ((LocalizationContext)bundle).getResourceBundle();
        }
        logger.warn("Can't handle bundle {}. Please report this bug. Using an empty bundle", bundle);
        return new EmptyBundle();
    }

    public Locale getLocale() {
        return this.localeFor("javax.servlet.jsp.jstl.fmt.locale");
    }

    public Locale getFallbackLocale() {
        return this.localeFor("javax.servlet.jsp.jstl.fmt.fallbackLocale");
    }

    private Locale localeFor(String key) {
        Object localeValue = this.findByKey(key);
        if (localeValue instanceof String) {
            return this.findLocalefromString((String)localeValue);
        }
        if (localeValue instanceof Locale) {
            return (Locale)localeValue;
        }
        return this.request.getRequest().getLocale();
    }

    private Object findByKey(String key) {
        Object value = Config.get((ServletRequest)this.request.getRequest(), (String)key);
        if (value != null) {
            return value;
        }
        value = Config.get((HttpSession)this.request.getRequest().getSession(), (String)key);
        if (value != null) {
            return value;
        }
        value = Config.get((ServletContext)this.request.getServletContext(), (String)key);
        if (value != null) {
            return value;
        }
        return this.request.getServletContext().getInitParameter(key);
    }

    public String getMessage(String key, Object ... parameters) {
        try {
            String content = this.getBundle().getString(key);
            return MessageFormat.format(content, parameters);
        }
        catch (MissingResourceException e) {
            return "???" + key + "???";
        }
    }

    private Locale findLocalefromString(String str) {
        if (!Strings.isNullOrEmpty((String)str)) {
            String[] arr = str.split("_");
            if (arr.length == 1) {
                return new Locale(arr[0]);
            }
            if (arr.length == 2) {
                return new Locale(arr[0], arr[1]);
            }
            return new Locale(arr[0], arr[1], arr[2]);
        }
        return null;
    }
}

