/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.core;

import br.com.caelum.vraptor.Result;
import br.com.caelum.vraptor.core.ExceptionRecorderParameter;
import br.com.caelum.vraptor.proxy.MethodInvocation;
import br.com.caelum.vraptor.proxy.Proxifier;
import br.com.caelum.vraptor.proxy.SuperMethod;
import com.google.common.collect.Lists;
import java.lang.reflect.Method;
import java.lang.reflect.TypeVariable;
import java.util.List;
import net.vidageek.mirror.dsl.Mirror;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExceptionRecorder<T>
implements MethodInvocation<T> {
    private final Proxifier proxifier;
    private final List<ExceptionRecorderParameter> parameters;

    public ExceptionRecorder(Proxifier proxifier) {
        this.proxifier = proxifier;
        this.parameters = Lists.newArrayList();
    }

    @Override
    public Object intercept(T proxy, Method method, Object[] args, SuperMethod superMethod) {
        this.parameters.add(new ExceptionRecorderParameter(args, method));
        if (Void.TYPE.equals(method.getReturnType())) {
            return null;
        }
        return this.proxifier.proxify(this.findReturnType(method, args), this);
    }

    private Class<?> findReturnType(Method method, Object[] args) {
        if (method.getGenericReturnType() instanceof TypeVariable) {
            if (args[0] instanceof Class) {
                return (Class)args[0];
            }
            return args[0].getClass();
        }
        return method.getReturnType();
    }

    public void replay(Result result) {
        Object current = result;
        for (ExceptionRecorderParameter p : this.parameters) {
            current = new Mirror().on(current).invoke().method(p.getMethod()).withArgs(p.getArgs());
        }
    }
}

