/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.core;

import br.com.caelum.vraptor.Convert;
import br.com.caelum.vraptor.Converter;
import br.com.caelum.vraptor.TwoWayConverter;
import br.com.caelum.vraptor.VRaptorException;
import br.com.caelum.vraptor.core.BaseComponents;
import br.com.caelum.vraptor.core.Converters;
import br.com.caelum.vraptor.ioc.ApplicationScoped;
import br.com.caelum.vraptor.ioc.Container;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ApplicationScoped
public final class DefaultConverters
implements Converters {
    private final LinkedList<Class<? extends Converter<?>>> classes;
    private final Logger logger = LoggerFactory.getLogger(DefaultConverters.class);
    private final Container container;

    public DefaultConverters(Container container) {
        this.container = container;
        this.classes = new LinkedList();
        this.logger.info("Registering bundled converters");
        for (Class<? extends Converter<?>> clazz : BaseComponents.getBundledConverters()) {
            this.logger.debug("bundled converter to be registered: " + clazz);
            this.register(clazz);
        }
    }

    @Override
    public void register(Class<? extends Converter<?>> converterClass) {
        if (!converterClass.isAnnotationPresent(Convert.class)) {
            throw new VRaptorException("The converter type " + converterClass.getName() + " should have the Convert annotation");
        }
        this.classes.addFirst(converterClass);
    }

    @Override
    public <T> Converter<T> to(Class<T> clazz) {
        if (!this.existsFor(clazz)) {
            throw new VRaptorException("Unable to find converter for " + clazz.getName());
        }
        return this.container.instanceFor(this.findConverterType(clazz));
    }

    private Class<? extends Converter<?>> findConverterType(Class<?> clazz) {
        for (Class clazz2 : this.classes) {
            Class<?> boundType = clazz2.getAnnotation(Convert.class).value();
            if (!boundType.isAssignableFrom(clazz)) continue;
            return clazz2;
        }
        return null;
    }

    @Override
    public boolean existsFor(Class<?> type) {
        return this.findConverterType(type) != null;
    }

    @Override
    public boolean existsTwoWayFor(Class<?> type) {
        Class<? extends Converter<?>> found = this.findConverterType(type);
        return found != null && TwoWayConverter.class.isAssignableFrom(found);
    }

    @Override
    public TwoWayConverter<?> twoWayConverterFor(Class<?> type) {
        if (!this.existsTwoWayFor(type)) {
            throw new VRaptorException("Unable to find two way converter for " + type.getName());
        }
        return (TwoWayConverter)this.container.instanceFor(this.findConverterType(type));
    }
}

