/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.converter;

import br.com.caelum.vraptor.Convert;
import br.com.caelum.vraptor.Converter;
import br.com.caelum.vraptor.converter.ConversionError;
import br.com.caelum.vraptor.core.Localization;
import br.com.caelum.vraptor.ioc.RequestScoped;
import com.google.common.base.Strings;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.Locale;
import java.util.ResourceBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Convert(value=Date.class)
@RequestScoped
public class LocaleBasedDateConverter
implements Converter<Date> {
    private final Localization localization;

    public LocaleBasedDateConverter(Localization localization) {
        this.localization = localization;
    }

    @Override
    public Date convert(String value, Class<? extends Date> type, ResourceBundle bundle) {
        if (Strings.isNullOrEmpty((String)value)) {
            return null;
        }
        Locale locale = this.localization.getLocale();
        if (locale == null) {
            locale = Locale.getDefault();
        }
        DateFormat format = DateFormat.getDateInstance(3, locale);
        try {
            return format.parse(value);
        }
        catch (ParseException e) {
            throw new ConversionError(MessageFormat.format(bundle.getString("is_not_a_valid_date"), value));
        }
    }
}

