/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.converter;

import br.com.caelum.vraptor.Convert;
import br.com.caelum.vraptor.Converter;
import br.com.caelum.vraptor.converter.ConversionError;
import br.com.caelum.vraptor.ioc.ApplicationScoped;
import com.google.common.base.Strings;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Convert(value=Boolean.class)
@ApplicationScoped
public class BooleanConverter
implements Converter<Boolean> {
    private static final Set<String> IS_TRUE = new HashSet<String>(Arrays.asList("TRUE", "1", "YES", "Y", "ON"));
    private static final Set<String> IS_FALSE = new HashSet<String>(Arrays.asList("FALSE", "0", "NO", "N", "OFF"));

    @Override
    public Boolean convert(String value, Class<? extends Boolean> type, ResourceBundle bundle) {
        if (Strings.isNullOrEmpty((String)value)) {
            return null;
        }
        if (this.matches(IS_TRUE, value = value.toUpperCase())) {
            return true;
        }
        if (this.matches(IS_FALSE, value)) {
            return false;
        }
        throw new ConversionError(MessageFormat.format(bundle.getString("is_not_a_valid_boolean"), value));
    }

    private boolean matches(Set<String> words, String value) {
        return words.contains(value);
    }
}

