/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.common.utils;

import java.util.Collection;
import java.util.UUID;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.powerjob.common.exception.PowerJobException;
import tech.powerjob.common.utils.Meaningless;
import tech.powerjob.common.utils.SupplierPlus;

public class CommonUtils {
    private static final Logger log = LoggerFactory.getLogger(CommonUtils.class);
    private static final int MAXIMUM_CAPACITY = 0x40000000;

    public static <T> T executeWithRetry(SupplierPlus<T> executor, int tryTimes, long intervalMS) throws Exception {
        if (tryTimes <= 1 || intervalMS <= 0L) {
            return executor.get();
        }
        for (int i = 1; i < tryTimes; ++i) {
            try {
                return executor.get();
            }
            catch (Exception e) {
                Thread.sleep(intervalMS);
                continue;
            }
        }
        return executor.get();
    }

    public static <T> T executeWithRetry0(SupplierPlus<T> executor) throws Exception {
        return CommonUtils.executeWithRetry(executor, 3, 100L);
    }

    public static boolean executeWithRetryV2(Supplier<Boolean> booleanExecutor, int tryTimes, long intervalMS) {
        if (tryTimes <= 1 || intervalMS <= 0L) {
            return booleanExecutor.get();
        }
        for (int i = 1; i < tryTimes; ++i) {
            try {
                if (booleanExecutor.get().booleanValue()) {
                    return true;
                }
                Thread.sleep(intervalMS);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return booleanExecutor.get();
    }

    public static String getInStringCondition(Collection<String> collection) {
        if (collection == null || collection.isEmpty()) {
            return "()";
        }
        StringBuilder sb = new StringBuilder(" ( ");
        collection.forEach(str -> sb.append("'").append((String)str).append("',"));
        return sb.replace(sb.length() - 1, sb.length(), " ) ").toString();
    }

    public static void executeIgnoreException(SupplierPlus<?> executor) {
        try {
            executor.get();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void executeIgnoreException(Meaningless executor) {
        try {
            executor.m();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static int formatSize(int cap) {
        int n = cap - 1;
        n |= n >>> 1;
        n |= n >>> 2;
        n |= n >>> 4;
        n |= n >>> 8;
        return (n |= n >>> 16) < 0 ? 1 : (n >= 0x40000000 ? 0x40000000 : n + 1);
    }

    public static <T> T requireNonNull(T obj, String msg) {
        if (obj == null) {
            throw new PowerJobException(msg);
        }
        if (obj instanceof String && StringUtils.isEmpty((CharSequence)((String)obj))) {
            throw new PowerJobException(msg);
        }
        return obj;
    }

    public static String formatTime(Long ts) {
        if (ts == null || ts <= 0L) {
            return "N/A";
        }
        try {
            return DateFormatUtils.format((long)ts, (String)"yyyy-MM-dd HH:mm:ss");
        }
        catch (Exception exception) {
            return "N/A";
        }
    }

    public static String genUUID() {
        return StringUtils.replace((String)UUID.randomUUID().toString(), (String)"-", (String)"");
    }

    public static void easySleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

