/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.shaded.com.github.dockerjava.core.exec;

import com.github.dockerjava.api.command.SaveImageCmd;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.shaded.com.github.dockerjava.core.DockerClientConfig;
import org.testcontainers.shaded.com.github.dockerjava.core.MediaType;
import org.testcontainers.shaded.com.github.dockerjava.core.WebTarget;
import org.testcontainers.shaded.com.github.dockerjava.core.exec.AbstrSyncDockerCmdExec;
import org.testcontainers.shaded.com.google.common.base.Strings;

public class SaveImageCmdExec
extends AbstrSyncDockerCmdExec<SaveImageCmd, InputStream>
implements SaveImageCmd.Exec {
    private static final Logger LOGGER = LoggerFactory.getLogger(SaveImageCmdExec.class);

    public SaveImageCmdExec(WebTarget baseResource, DockerClientConfig dockerClientConfig) {
        super(baseResource, dockerClientConfig);
    }

    @Override
    protected InputStream execute(SaveImageCmd command) {
        String name = command.getName();
        if (!Strings.isNullOrEmpty(command.getTag())) {
            name = name + ":" + command.getTag();
        }
        WebTarget webResource = this.getBaseResource().path("/images/" + name + "/get");
        LOGGER.trace("GET: {}", (Object)webResource);
        return webResource.request().accept(MediaType.APPLICATION_JSON).get();
    }
}

