/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.support.management;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import org.springframework.integration.support.management.ExponentialMovingAverage;
import org.springframework.integration.support.management.Statistics;

public class ExponentialMovingAverageRatio {
    private volatile double t0;
    private volatile long count;
    private volatile double min = Double.MAX_VALUE;
    private volatile double max;
    private final double lapse;
    private final Deque<Long> times = new ArrayDeque<Long>();
    private final Deque<Integer> values = new ArrayDeque<Integer>();
    private final int retention;
    private final int window;
    private final double factor;

    public ExponentialMovingAverageRatio(double lapsePeriod, int window) {
        this(lapsePeriod, window, false);
    }

    public ExponentialMovingAverageRatio(double lapsePeriod, int window, boolean millis) {
        this.lapse = lapsePeriod > 0.0 ? 0.001 / lapsePeriod : 0.0;
        this.window = window;
        this.retention = window * 5;
        this.factor = millis ? 1000000.0 : 1.0;
        this.t0 = (double)System.nanoTime() / this.factor;
    }

    public void success() {
        this.append(1, System.nanoTime());
    }

    public void success(long t) {
        this.append(1, t);
    }

    public void failure() {
        this.append(0, System.nanoTime());
    }

    public void failure(long t) {
        this.append(0, t);
    }

    public synchronized void reset() {
        this.t0 = (double)System.nanoTime() / this.factor;
        this.times.clear();
        this.values.clear();
        this.count = 0L;
        this.max = 0.0;
        this.min = Double.MAX_VALUE;
    }

    private synchronized void append(int value, long t) {
        if (this.times.size() == this.retention) {
            this.times.poll();
            this.values.poll();
        }
        this.times.add(t);
        this.values.add(value);
        ++this.count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Statistics calcStatic() {
        long currentCount;
        ArrayList<Integer> copyValues;
        ArrayList<Long> copyTimes;
        ExponentialMovingAverageRatio exponentialMovingAverageRatio = this;
        synchronized (exponentialMovingAverageRatio) {
            copyTimes = new ArrayList<Long>(this.times);
            copyValues = new ArrayList<Integer>(this.values);
            currentCount = this.count;
        }
        ExponentialMovingAverage cumulative = new ExponentialMovingAverage(this.window);
        double currentT0 = 0.0;
        double sum = 0.0;
        double weight = 0.0;
        double currentMin = this.min;
        double currentMax = this.max;
        int size = copyTimes.size();
        Iterator valuesIterator = copyValues.iterator();
        for (Long time : copyTimes) {
            double t = (double)time.longValue() / this.factor;
            if (size == 1) {
                currentT0 = this.t0;
            } else if (currentT0 == 0.0) {
                currentT0 = t;
                valuesIterator.next();
                continue;
            }
            double alpha = Math.exp((currentT0 - t) * this.lapse);
            currentT0 = t;
            sum = alpha * sum + (double)((Integer)valuesIterator.next()).intValue();
            weight = alpha * weight + 1.0;
            double value = sum / weight;
            if (value > currentMax) {
                currentMax = value;
            }
            if (value < currentMin) {
                currentMin = value;
            }
            cumulative.append(value);
        }
        ExponentialMovingAverageRatio exponentialMovingAverageRatio2 = this;
        synchronized (exponentialMovingAverageRatio2) {
            if (currentMax > this.max) {
                this.max = currentMax;
            }
            if (currentMin < this.min) {
                this.min = currentMin;
            }
        }
        return new Statistics(currentCount, currentMin < Double.MAX_VALUE ? currentMin : 0.0, currentMax, cumulative.getMean(), cumulative.getStandardDeviation());
    }

    public int getCount() {
        return (int)this.count;
    }

    public long getCountLong() {
        return this.count;
    }

    public double getTimeSinceLastMeasurement() {
        double delta = (double)System.nanoTime() - this.lastTime();
        return delta / 1000.0 / this.factor;
    }

    public double getMean() {
        if (this.count == 0L) {
            return 1.0;
        }
        return this.decayMean(this.calcStatic());
    }

    private double decayMean(Statistics statistics) {
        double t = (double)System.nanoTime() / this.factor;
        double mean = statistics.getMean();
        double alpha = Math.exp((this.lastTime() / this.factor - t) * this.lapse);
        return alpha * mean + 1.0 - alpha;
    }

    private synchronized double lastTime() {
        if (this.times.size() > 0) {
            return this.times.peekLast().longValue();
        }
        return this.t0 * this.factor;
    }

    public double getStandardDeviation() {
        return this.calcStatic().getStandardDeviation();
    }

    public double getMax() {
        return this.calcStatic().getMax();
    }

    public double getMin() {
        return this.calcStatic().getMin();
    }

    public Statistics getStatistics() {
        Statistics staticStats = this.calcStatic();
        staticStats.setMean(this.decayMean(staticStats));
        return staticStats;
    }

    public String toString() {
        return String.format("[%s, timeSinceLast=%f]", this.getStatistics(), this.getTimeSinceLastMeasurement());
    }
}

