/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.endpoint;

import org.springframework.integration.StaticMessageHeaderAccessor;
import org.springframework.integration.acks.AckUtils;
import org.springframework.integration.acks.AcknowledgmentCallback;
import org.springframework.integration.core.MessageSource;
import org.springframework.integration.endpoint.PollingOperations;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.MessageHandlingException;
import org.springframework.util.Assert;

public class MessageSourcePollingTemplate
implements PollingOperations {
    private final MessageSource<?> source;

    public MessageSourcePollingTemplate(MessageSource<?> source) {
        Assert.notNull(source, (String)"'source' cannot be null");
        this.source = source;
    }

    @Override
    public boolean poll(MessageHandler handler) {
        Assert.notNull((Object)handler, (String)"'handler' cannot be null");
        Message<?> message = this.source.receive();
        if (message != null) {
            AcknowledgmentCallback ackCallback = StaticMessageHeaderAccessor.getAcknowledgmentCallback(message);
            try {
                handler.handleMessage(message);
                AckUtils.autoAck(ackCallback);
            }
            catch (Exception e) {
                AckUtils.autoNack(ackCallback);
                throw new MessageHandlingException(message, (Throwable)e);
            }
            return true;
        }
        return false;
    }
}

