/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.dsl.context;

import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.context.SmartLifecycle;
import org.springframework.integration.dsl.StandardIntegrationFlow;
import org.springframework.util.ObjectUtils;

class IntegrationFlowLifecycleAdvice
implements MethodInterceptor {
    private final StandardIntegrationFlow delegate;

    IntegrationFlowLifecycleAdvice(StandardIntegrationFlow delegate) {
        this.delegate = delegate;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Object target = invocation.getThis();
        String method = invocation.getMethod().getName();
        Object result = null;
        if ("getInputChannel".equals(method)) {
            result = invocation.proceed();
            if (result == null) {
                result = this.delegate.getInputChannel();
            }
        } else {
            if (target instanceof SmartLifecycle) {
                result = invocation.proceed();
            }
            switch (method) {
                case "start": {
                    this.delegate.start();
                    break;
                }
                case "stop": {
                    Object[] arguments = invocation.getArguments();
                    if (!ObjectUtils.isEmpty((Object[])arguments)) {
                        this.delegate.stop((Runnable)arguments[0]);
                        break;
                    }
                    this.delegate.stop();
                    break;
                }
                case "isRunning": {
                    if (result != null) break;
                    result = this.delegate.isRunning();
                    break;
                }
                case "isAutoStartup": {
                    if (result != null) break;
                    result = this.delegate.isAutoStartup();
                    break;
                }
                case "getPhase": {
                    if (result != null) break;
                    result = this.delegate.getPhase();
                }
            }
        }
        return result;
    }
}

