/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.channel.interceptor;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.context.Lifecycle;
import org.springframework.integration.channel.ChannelInterceptorAware;
import org.springframework.integration.channel.interceptor.VetoCapableInterceptor;
import org.springframework.integration.core.MessageSelector;
import org.springframework.integration.support.channel.BeanFactoryChannelResolver;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedOperation;
import org.springframework.jmx.export.annotation.ManagedResource;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.support.ChannelInterceptor;
import org.springframework.util.Assert;

@ManagedResource
public class WireTap
implements ChannelInterceptor,
Lifecycle,
VetoCapableInterceptor,
BeanFactoryAware {
    private static final Log logger = LogFactory.getLog(WireTap.class);
    private volatile MessageChannel channel;
    private volatile String channelName;
    private volatile long timeout = 0L;
    private final MessageSelector selector;
    private volatile boolean running = true;
    private BeanFactory beanFactory;

    public WireTap(MessageChannel channel) {
        this(channel, null);
    }

    public WireTap(MessageChannel channel, MessageSelector selector) {
        Assert.notNull((Object)channel, (String)"channel must not be null");
        this.channel = channel;
        this.selector = selector;
    }

    public WireTap(String channelName) {
        this(channelName, null);
    }

    public WireTap(String channelName, MessageSelector selector) {
        Assert.hasText((String)channelName, (String)"channelName must not be empty");
        this.channelName = channelName;
        this.selector = selector;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        if (this.beanFactory == null) {
            this.beanFactory = beanFactory;
        }
    }

    @ManagedAttribute
    public boolean isRunning() {
        return this.running;
    }

    @ManagedOperation
    public void start() {
        this.running = true;
    }

    @ManagedOperation
    public void stop() {
        this.running = false;
    }

    public Message<?> preSend(Message<?> message, MessageChannel channel) {
        MessageChannel wireTapChannel = this.getChannel();
        if (wireTapChannel.equals(channel)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("WireTap is refusing to intercept its own channel '" + wireTapChannel + "'"));
            }
            return message;
        }
        if (this.running && (this.selector == null || this.selector.accept(message))) {
            boolean sent;
            boolean bl = sent = this.timeout >= 0L ? wireTapChannel.send(message, this.timeout) : wireTapChannel.send(message);
            if (!sent && logger.isWarnEnabled()) {
                logger.warn((Object)("failed to send message to WireTap channel '" + wireTapChannel + "'"));
            }
        }
        return message;
    }

    @Override
    public boolean shouldIntercept(String beanName, ChannelInterceptorAware channel) {
        return !this.getChannel().equals(channel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MessageChannel getChannel() {
        if (this.channelName != null) {
            WireTap wireTap = this;
            synchronized (wireTap) {
                if (this.channelName != null) {
                    this.channel = new BeanFactoryChannelResolver(this.beanFactory).resolveDestination(this.channelName);
                    this.channelName = null;
                }
            }
        }
        return this.channel;
    }
}

