/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.server.support;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.AbstractHttpClient;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.impl.HttpSolrServer;
import org.springframework.data.solr.server.support.SolrServerFactoryBase;
import org.springframework.data.solr.server.support.SolrServerUtils;
import org.springframework.util.Assert;

public class HttpSolrServerFactory
extends SolrServerFactoryBase {
    private String core;
    private Credentials credentials;
    private String authPolicy;

    protected HttpSolrServerFactory() {
    }

    public HttpSolrServerFactory(SolrServer solrServer) {
        this(solrServer, null);
    }

    public HttpSolrServerFactory(SolrServer solrServer, String core) {
        this(solrServer, core, null, null);
    }

    public HttpSolrServerFactory(SolrServer solrServer, String core, Credentials credentials, String authPolicy) {
        super(solrServer);
        Assert.notNull((Object)solrServer, (String)"SolrServer must not be null");
        if (authPolicy != null) {
            Assert.hasText((String)authPolicy);
        }
        this.core = core;
        this.credentials = credentials;
        this.authPolicy = authPolicy;
        this.appendCoreToBaseUrl(this.core, this.getSolrServer());
        this.appendAuthentication(this.credentials, this.authPolicy, this.getSolrServer());
    }

    @Override
    public List<String> getCores() {
        return this.core != null ? Arrays.asList(this.core) : Collections.emptyList();
    }

    @Override
    public SolrServer getSolrServer(String core) {
        return this.getSolrServer();
    }

    protected void appendCoreToBaseUrl(String core, SolrServer solrServer) {
        if (StringUtils.isNotEmpty((CharSequence)core) && this.isHttpSolrServer(solrServer)) {
            HttpSolrServer httpSolrServer = (HttpSolrServer)solrServer;
            String url = SolrServerUtils.appendCoreToBaseUrl(httpSolrServer.getBaseURL(), core);
            httpSolrServer.setBaseURL(url);
        }
    }

    private void appendAuthentication(Credentials credentials, String authPolicy, SolrServer solrServer) {
        if (this.isHttpSolrServer(solrServer)) {
            HttpSolrServer httpSolrServer = (HttpSolrServer)solrServer;
            if (credentials != null && StringUtils.isNotBlank((CharSequence)authPolicy) && this.assertHttpClientInstance(httpSolrServer.getHttpClient())) {
                AbstractHttpClient httpClient = (AbstractHttpClient)httpSolrServer.getHttpClient();
                httpClient.getCredentialsProvider().setCredentials(new AuthScope(AuthScope.ANY), credentials);
                httpClient.getParams().setParameter("http.auth.target-scheme-pref", Arrays.asList(authPolicy));
            }
        }
    }

    private boolean assertHttpClientInstance(HttpClient httpClient) {
        Assert.isInstanceOf(AbstractHttpClient.class, (Object)httpClient, (String)"HttpClient has to be derivate of AbstractHttpClient in order to allow authentication.");
        return true;
    }
}

