/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce;

import io.lettuce.core.pubsub.RedisPubSubListener;
import org.springframework.data.redis.connection.DefaultMessage;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.connection.SubscriptionListener;
import org.springframework.util.Assert;

class LettuceMessageListener
implements RedisPubSubListener<byte[], byte[]> {
    private final MessageListener listener;
    private final SubscriptionListener subscriptionListener;

    LettuceMessageListener(MessageListener listener, SubscriptionListener subscriptionListener) {
        Assert.notNull((Object)listener, (String)"MessageListener must not be null!");
        Assert.notNull((Object)subscriptionListener, (String)"SubscriptionListener must not be null!");
        this.listener = listener;
        this.subscriptionListener = subscriptionListener;
    }

    public void message(byte[] channel, byte[] message) {
        this.listener.onMessage(new DefaultMessage(channel, message), null);
    }

    public void message(byte[] pattern, byte[] channel, byte[] message) {
        this.listener.onMessage(new DefaultMessage(channel, message), pattern);
    }

    public void subscribed(byte[] channel, long count) {
        this.subscriptionListener.onChannelSubscribed(channel, count);
    }

    public void psubscribed(byte[] pattern, long count) {
        this.subscriptionListener.onPatternSubscribed(pattern, count);
    }

    public void unsubscribed(byte[] channel, long count) {
        this.subscriptionListener.onChannelUnsubscribed(channel, count);
    }

    public void punsubscribed(byte[] pattern, long count) {
        this.subscriptionListener.onPatternUnsubscribed(pattern, count);
    }
}

