/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.jedis;

import java.time.Duration;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.springframework.data.redis.connection.DataType;
import org.springframework.data.redis.connection.RedisKeyCommands;
import org.springframework.data.redis.connection.SortParameters;
import org.springframework.data.redis.connection.ValueEncoding;
import org.springframework.data.redis.connection.convert.Converters;
import org.springframework.data.redis.connection.jedis.JedisConnection;
import org.springframework.data.redis.connection.jedis.JedisConverters;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.ScanCursor;
import org.springframework.data.redis.core.ScanIteration;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import redis.clients.jedis.BinaryJedis;
import redis.clients.jedis.MultiKeyPipelineBase;
import redis.clients.jedis.PipelineBase;
import redis.clients.jedis.ScanParams;
import redis.clients.jedis.ScanResult;
import redis.clients.jedis.SortingParams;
import redis.clients.jedis.commands.BinaryJedisCommands;
import redis.clients.jedis.commands.BinaryRedisPipeline;

class JedisKeyCommands
implements RedisKeyCommands {
    private final JedisConnection connection;

    JedisKeyCommands(JedisConnection connection) {
        this.connection = connection;
    }

    @Override
    public Boolean exists(byte[] key) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return this.connection.invoke().just(BinaryJedis::exists, PipelineBase::exists, key);
    }

    @Override
    @Nullable
    public Long exists(byte[] ... keys) {
        Assert.notNull((Object)keys, (String)"Keys must not be null!");
        Assert.noNullElements((Object[])keys, (String)"Keys must not contain null elements!");
        return this.connection.invoke().just(BinaryJedis::exists, MultiKeyPipelineBase::exists, keys);
    }

    @Override
    public Long del(byte[] ... keys) {
        Assert.notNull((Object)keys, (String)"Keys must not be null!");
        Assert.noNullElements((Object[])keys, (String)"Keys must not contain null elements!");
        return this.connection.invoke().just(BinaryJedis::del, MultiKeyPipelineBase::del, keys);
    }

    @Override
    @Nullable
    public Long unlink(byte[] ... keys) {
        Assert.notNull((Object)keys, (String)"Keys must not be null!");
        return this.connection.invoke().just(BinaryJedis::unlink, MultiKeyPipelineBase::unlink, keys);
    }

    @Override
    public DataType type(byte[] key) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return this.connection.invoke().from(BinaryJedis::type, PipelineBase::type, key).get(JedisConverters.stringToDataType());
    }

    @Override
    @Nullable
    public Long touch(byte[] ... keys) {
        Assert.notNull((Object)keys, (String)"Keys must not be null!");
        return this.connection.invoke().just(BinaryJedis::touch, MultiKeyPipelineBase::touch, keys);
    }

    @Override
    public Set<byte[]> keys(byte[] pattern) {
        Assert.notNull((Object)pattern, (String)"Pattern must not be null!");
        return this.connection.invoke().just(BinaryJedis::keys, MultiKeyPipelineBase::keys, pattern);
    }

    @Override
    public Cursor<byte[]> scan(ScanOptions options) {
        return this.scan(0L, options != null ? options : ScanOptions.NONE);
    }

    public Cursor<byte[]> scan(long cursorId, ScanOptions options) {
        return new ScanCursor<byte[]>(cursorId, options){

            @Override
            protected ScanIteration<byte[]> doScan(long cursorId, ScanOptions options) {
                if (JedisKeyCommands.this.isQueueing() || JedisKeyCommands.this.isPipelined()) {
                    throw new UnsupportedOperationException("'SCAN' cannot be called in pipeline / transaction mode.");
                }
                ScanParams params = JedisConverters.toScanParams(options);
                ScanResult result = JedisKeyCommands.this.connection.getJedis().scan(Long.toString(cursorId), params);
                return new ScanIteration<byte[]>(Long.parseLong(result.getCursor()), JedisConverters.stringListToByteList().convert(result.getResult()));
            }

            @Override
            protected void doClose() {
                JedisKeyCommands.this.connection.close();
            }
        }.open();
    }

    @Override
    public byte[] randomKey() {
        return this.connection.invoke().just(BinaryJedis::randomBinaryKey, MultiKeyPipelineBase::randomKeyBinary);
    }

    @Override
    public void rename(byte[] sourceKey, byte[] targetKey) {
        Assert.notNull((Object)sourceKey, (String)"Source key must not be null!");
        Assert.notNull((Object)targetKey, (String)"Target key must not be null!");
        this.connection.invokeStatus().just(BinaryJedis::rename, MultiKeyPipelineBase::rename, sourceKey, targetKey);
    }

    @Override
    public Boolean renameNX(byte[] sourceKey, byte[] targetKey) {
        Assert.notNull((Object)sourceKey, (String)"Source key must not be null!");
        Assert.notNull((Object)targetKey, (String)"Target key must not be null!");
        return this.connection.invoke().from(BinaryJedis::renamenx, MultiKeyPipelineBase::renamenx, sourceKey, targetKey).get(JedisConverters.longToBoolean());
    }

    @Override
    public Boolean expire(byte[] key, long seconds) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        if (seconds > Integer.MAX_VALUE) {
            return this.pExpire(key, TimeUnit.SECONDS.toMillis(seconds));
        }
        return this.connection.invoke().from(BinaryJedisCommands::expire, BinaryRedisPipeline::expire, key, (int)seconds).get(JedisConverters.longToBoolean());
    }

    @Override
    public Boolean pExpire(byte[] key, long millis) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return this.connection.invoke().from(BinaryJedis::pexpire, PipelineBase::pexpire, key, millis).get(JedisConverters.longToBoolean());
    }

    @Override
    public Boolean expireAt(byte[] key, long unixTime) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return this.connection.invoke().from(BinaryJedis::expireAt, PipelineBase::expireAt, key, unixTime).get(JedisConverters.longToBoolean());
    }

    @Override
    public Boolean pExpireAt(byte[] key, long unixTimeInMillis) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return this.connection.invoke().from(BinaryJedis::pexpireAt, PipelineBase::pexpireAt, key, unixTimeInMillis).get(JedisConverters.longToBoolean());
    }

    @Override
    public Boolean persist(byte[] key) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return this.connection.invoke().from(BinaryJedis::persist, PipelineBase::persist, key).get(JedisConverters.longToBoolean());
    }

    @Override
    public Boolean move(byte[] key, int dbIndex) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return this.connection.invoke().from(BinaryJedis::move, PipelineBase::move, key, dbIndex).get(JedisConverters.longToBoolean());
    }

    @Override
    public Long ttl(byte[] key) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return this.connection.invoke().just(BinaryJedis::ttl, PipelineBase::ttl, key);
    }

    @Override
    public Long ttl(byte[] key, TimeUnit timeUnit) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return this.connection.invoke().from(BinaryJedis::ttl, PipelineBase::ttl, key).get(Converters.secondsToTimeUnit(timeUnit));
    }

    @Override
    public Long pTtl(byte[] key) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return this.connection.invoke().just(BinaryJedis::pttl, PipelineBase::pttl, key);
    }

    @Override
    public Long pTtl(byte[] key, TimeUnit timeUnit) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return this.connection.invoke().from(BinaryJedis::pttl, PipelineBase::pttl, key).get(Converters.millisecondsToTimeUnit(timeUnit));
    }

    @Override
    public List<byte[]> sort(byte[] key, SortParameters params) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        SortingParams sortParams = JedisConverters.toSortingParams(params);
        if (sortParams != null) {
            return this.connection.invoke().just(BinaryJedis::sort, PipelineBase::sort, key, sortParams);
        }
        return this.connection.invoke().just(BinaryJedis::sort, PipelineBase::sort, key);
    }

    @Override
    public Long sort(byte[] key, @Nullable SortParameters params, byte[] storeKey) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        SortingParams sortParams = JedisConverters.toSortingParams(params);
        if (sortParams != null) {
            return this.connection.invoke().just(BinaryJedis::sort, MultiKeyPipelineBase::sort, key, sortParams, storeKey);
        }
        return this.connection.invoke().just(BinaryJedis::sort, MultiKeyPipelineBase::sort, key, storeKey);
    }

    @Override
    public byte[] dump(byte[] key) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return this.connection.invoke().just(BinaryJedis::dump, PipelineBase::dump, key);
    }

    @Override
    public void restore(byte[] key, long ttlInMillis, byte[] serializedValue, boolean replace) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)serializedValue, (String)"Serialized value must not be null!");
        if (replace) {
            this.connection.invokeStatus().just(BinaryJedisCommands::restoreReplace, BinaryRedisPipeline::restoreReplace, key, (int)ttlInMillis, serializedValue);
            return;
        }
        if (ttlInMillis > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("TtlInMillis must be less than Integer.MAX_VALUE for restore in Jedis.");
        }
        this.connection.invokeStatus().just(BinaryJedisCommands::restore, BinaryRedisPipeline::restore, key, (int)ttlInMillis, serializedValue);
    }

    @Override
    @Nullable
    public ValueEncoding encodingOf(byte[] key) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return this.connection.invoke().from(BinaryJedis::objectEncoding, PipelineBase::objectEncoding, key).getOrElse(JedisConverters::toEncoding, () -> ValueEncoding.RedisValueEncoding.VACANT);
    }

    @Override
    @Nullable
    public Duration idletime(byte[] key) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return (Duration)this.connection.invoke().from(BinaryJedis::objectIdletime, PipelineBase::objectIdletime, key).get(Converters::secondsToDuration);
    }

    @Override
    @Nullable
    public Long refcount(byte[] key) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return this.connection.invoke().just(BinaryJedis::objectRefcount, PipelineBase::objectRefcount, key);
    }

    private boolean isPipelined() {
        return this.connection.isPipelined();
    }

    private boolean isQueueing() {
        return this.connection.isQueueing();
    }
}

