/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.jedis;

import java.nio.charset.StandardCharsets;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.data.redis.connection.RedisZSetCommands;
import org.springframework.data.redis.connection.convert.Converters;
import org.springframework.data.redis.connection.jedis.JedisConnection;
import org.springframework.data.redis.connection.jedis.JedisConverters;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.KeyBoundCursor;
import org.springframework.data.redis.core.ScanIteration;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.util.Assert;
import redis.clients.jedis.BinaryJedis;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.MultiKeyPipelineBase;
import redis.clients.jedis.PipelineBase;
import redis.clients.jedis.ScanParams;
import redis.clients.jedis.ScanResult;
import redis.clients.jedis.ZParams;

class JedisZSetCommands
implements RedisZSetCommands {
    private final JedisConnection connection;

    JedisZSetCommands(JedisConnection connection) {
        this.connection = connection;
    }

    @Override
    public Boolean zAdd(byte[] key, double score, byte[] value, RedisZSetCommands.ZAddArgs args) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)value, (String)"Value must not be null!");
        return (Boolean)this.connection.invoke().from(BinaryJedis::zadd, PipelineBase::zadd, key, score, value, JedisConverters.toZAddParams(args)).get(Converters::toBoolean);
    }

    @Override
    public Long zAdd(byte[] key, Set<RedisZSetCommands.Tuple> tuples, RedisZSetCommands.ZAddArgs args) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull(tuples, (String)"Tuples must not be null!");
        return this.connection.invoke().just(BinaryJedis::zadd, PipelineBase::zadd, key, JedisConverters.toTupleMap(tuples), JedisConverters.toZAddParams(args));
    }

    @Override
    public Long zRem(byte[] key, byte[] ... values) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)values, (String)"Values must not be null!");
        Assert.noNullElements((Object[])values, (String)"Values must not contain null elements!");
        return this.connection.invoke().just(BinaryJedis::zrem, PipelineBase::zrem, key, values);
    }

    @Override
    public Double zIncrBy(byte[] key, double increment, byte[] value) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)value, (String)"Value must not be null!");
        return this.connection.invoke().just(BinaryJedis::zincrby, PipelineBase::zincrby, key, increment, value);
    }

    @Override
    public Long zRank(byte[] key, byte[] value) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)value, (String)"Value must not be null!");
        return this.connection.invoke().just(BinaryJedis::zrank, PipelineBase::zrank, key, value);
    }

    @Override
    public Long zRevRank(byte[] key, byte[] value) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return this.connection.invoke().just(BinaryJedis::zrevrank, PipelineBase::zrevrank, key, value);
    }

    @Override
    public Set<byte[]> zRange(byte[] key, long start, long end) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return this.connection.invoke().just(BinaryJedis::zrange, PipelineBase::zrange, key, start, end);
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRangeWithScores(byte[] key, long start, long end) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return this.connection.invoke().fromMany(BinaryJedis::zrangeWithScores, PipelineBase::zrangeWithScores, key, start, end).toSet(JedisConverters::toTuple);
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRangeByScoreWithScores(byte[] key, RedisZSetCommands.Range range, RedisZSetCommands.Limit limit) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)range, (String)"Range for ZRANGEBYSCOREWITHSCORES must not be null!");
        Assert.notNull((Object)limit, (String)"Limit must not be null! Use Limit.unlimited() instead.");
        byte[] min = JedisConverters.boundaryToBytesForZRange(range.getMin(), JedisConverters.NEGATIVE_INFINITY_BYTES);
        byte[] max = JedisConverters.boundaryToBytesForZRange(range.getMax(), JedisConverters.POSITIVE_INFINITY_BYTES);
        if (!limit.isUnlimited()) {
            return this.connection.invoke().fromMany(BinaryJedis::zrangeByScoreWithScores, PipelineBase::zrangeByScoreWithScores, key, min, max, limit.getOffset(), limit.getCount()).toSet(JedisConverters::toTuple);
        }
        return this.connection.invoke().fromMany(BinaryJedis::zrangeByScoreWithScores, PipelineBase::zrangeByScoreWithScores, key, min, max).toSet(JedisConverters::toTuple);
    }

    @Override
    public Set<byte[]> zRevRange(byte[] key, long start, long end) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return this.connection.invoke().just(BinaryJedis::zrevrange, PipelineBase::zrevrange, key, start, end);
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRevRangeWithScores(byte[] key, long start, long end) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return this.connection.invoke().fromMany(BinaryJedis::zrevrangeWithScores, PipelineBase::zrevrangeWithScores, key, start, end).toSet(JedisConverters::toTuple);
    }

    @Override
    public Set<byte[]> zRevRangeByScore(byte[] key, RedisZSetCommands.Range range, RedisZSetCommands.Limit limit) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)range, (String)"Range for ZREVRANGEBYSCORE must not be null!");
        Assert.notNull((Object)limit, (String)"Limit must not be null! Use Limit.unlimited() instead.");
        byte[] min = JedisConverters.boundaryToBytesForZRange(range.getMin(), JedisConverters.NEGATIVE_INFINITY_BYTES);
        byte[] max = JedisConverters.boundaryToBytesForZRange(range.getMax(), JedisConverters.POSITIVE_INFINITY_BYTES);
        if (!limit.isUnlimited()) {
            return this.connection.invoke().just(BinaryJedis::zrevrangeByScore, PipelineBase::zrevrangeByScore, key, max, min, limit.getOffset(), limit.getCount());
        }
        return this.connection.invoke().just(BinaryJedis::zrevrangeByScore, PipelineBase::zrevrangeByScore, key, max, min);
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRevRangeByScoreWithScores(byte[] key, RedisZSetCommands.Range range, RedisZSetCommands.Limit limit) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)range, (String)"Range for ZREVRANGEBYSCOREWITHSCORES must not be null!");
        Assert.notNull((Object)limit, (String)"Limit must not be null! Use Limit.unlimited() instead.");
        byte[] min = JedisConverters.boundaryToBytesForZRange(range.getMin(), JedisConverters.NEGATIVE_INFINITY_BYTES);
        byte[] max = JedisConverters.boundaryToBytesForZRange(range.getMax(), JedisConverters.POSITIVE_INFINITY_BYTES);
        if (!limit.isUnlimited()) {
            return this.connection.invoke().fromMany(BinaryJedis::zrevrangeByScoreWithScores, PipelineBase::zrevrangeByScoreWithScores, key, max, min, limit.getOffset(), limit.getCount()).toSet(JedisConverters::toTuple);
        }
        return this.connection.invoke().fromMany(BinaryJedis::zrevrangeByScoreWithScores, PipelineBase::zrevrangeByScoreWithScores, key, max, min).toSet(JedisConverters::toTuple);
    }

    @Override
    public Long zCount(byte[] key, double min, double max) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return this.connection.invoke().just(BinaryJedis::zcount, PipelineBase::zcount, key, min, max);
    }

    @Override
    public Long zCount(byte[] key, RedisZSetCommands.Range range) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)range, (String)"Range must not be null!");
        byte[] min = JedisConverters.boundaryToBytesForZRange(range.getMin(), JedisConverters.NEGATIVE_INFINITY_BYTES);
        byte[] max = JedisConverters.boundaryToBytesForZRange(range.getMax(), JedisConverters.POSITIVE_INFINITY_BYTES);
        return this.connection.invoke().just(BinaryJedis::zcount, PipelineBase::zcount, key, min, max);
    }

    @Override
    public Long zLexCount(byte[] key, RedisZSetCommands.Range range) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)range, (String)"Range must not be null!");
        byte[] min = JedisConverters.boundaryToBytesForZRangeByLex(range.getMin(), JedisConverters.MINUS_BYTES);
        byte[] max = JedisConverters.boundaryToBytesForZRangeByLex(range.getMax(), JedisConverters.PLUS_BYTES);
        return this.connection.invoke().just(BinaryJedis::zlexcount, PipelineBase::zlexcount, key, min, max);
    }

    @Override
    public Long zCard(byte[] key) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return this.connection.invoke().just(BinaryJedis::zcard, PipelineBase::zcard, key);
    }

    @Override
    public Double zScore(byte[] key, byte[] value) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)value, (String)"Value must not be null!");
        return this.connection.invoke().just(BinaryJedis::zscore, PipelineBase::zscore, key, value);
    }

    @Override
    public Long zRemRange(byte[] key, long start, long end) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return this.connection.invoke().just(BinaryJedis::zremrangeByRank, PipelineBase::zremrangeByRank, key, start, end);
    }

    @Override
    public Long zRemRangeByLex(byte[] key, RedisZSetCommands.Range range) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)range, (String)"Range must not be null for ZREMRANGEBYLEX!");
        byte[] min = JedisConverters.boundaryToBytesForZRangeByLex(range.getMin(), JedisConverters.MINUS_BYTES);
        byte[] max = JedisConverters.boundaryToBytesForZRangeByLex(range.getMax(), JedisConverters.PLUS_BYTES);
        return this.connection.invoke().just(BinaryJedis::zremrangeByLex, PipelineBase::zremrangeByLex, key, min, max);
    }

    @Override
    public Long zRemRangeByScore(byte[] key, RedisZSetCommands.Range range) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)range, (String)"Range for ZREMRANGEBYSCORE must not be null!");
        byte[] min = JedisConverters.boundaryToBytesForZRange(range.getMin(), JedisConverters.NEGATIVE_INFINITY_BYTES);
        byte[] max = JedisConverters.boundaryToBytesForZRange(range.getMax(), JedisConverters.POSITIVE_INFINITY_BYTES);
        return this.connection.invoke().just(BinaryJedis::zremrangeByScore, PipelineBase::zremrangeByScore, key, min, max);
    }

    @Override
    public Long zUnionStore(byte[] destKey, RedisZSetCommands.Aggregate aggregate, RedisZSetCommands.Weights weights, byte[] ... sets) {
        Assert.notNull((Object)destKey, (String)"Destination key must not be null!");
        Assert.notNull((Object)sets, (String)"Source sets must not be null!");
        Assert.notNull((Object)weights, (String)"Weights must not be null!");
        Assert.noNullElements((Object[])sets, (String)"Source sets must not contain null elements!");
        Assert.isTrue((weights.size() == sets.length ? 1 : 0) != 0, () -> String.format("The number of weights (%d) must match the number of source sets (%d)!", weights.size(), sets.length));
        ZParams zparams = new ZParams().weights(weights.toArray()).aggregate(ZParams.Aggregate.valueOf((String)aggregate.name()));
        return this.connection.invoke().just(BinaryJedis::zunionstore, MultiKeyPipelineBase::zunionstore, destKey, zparams, sets);
    }

    @Override
    public Long zUnionStore(byte[] destKey, byte[] ... sets) {
        Assert.notNull((Object)destKey, (String)"Destination key must not be null!");
        Assert.notNull((Object)sets, (String)"Source sets must not be null!");
        Assert.noNullElements((Object[])sets, (String)"Source sets must not contain null elements!");
        return this.connection.invoke().just(BinaryJedis::zunionstore, MultiKeyPipelineBase::zunionstore, destKey, sets);
    }

    @Override
    public Long zInterStore(byte[] destKey, RedisZSetCommands.Aggregate aggregate, RedisZSetCommands.Weights weights, byte[] ... sets) {
        Assert.notNull((Object)destKey, (String)"Destination key must not be null!");
        Assert.notNull((Object)sets, (String)"Source sets must not be null!");
        Assert.noNullElements((Object[])sets, (String)"Source sets must not contain null elements!");
        Assert.isTrue((weights.size() == sets.length ? 1 : 0) != 0, () -> String.format("The number of weights (%d) must match the number of source sets (%d)!", weights.size(), sets.length));
        ZParams zparams = new ZParams().weights(weights.toArray()).aggregate(ZParams.Aggregate.valueOf((String)aggregate.name()));
        return this.connection.invoke().just(BinaryJedis::zinterstore, MultiKeyPipelineBase::zinterstore, destKey, zparams, sets);
    }

    @Override
    public Long zInterStore(byte[] destKey, byte[] ... sets) {
        Assert.notNull((Object)destKey, (String)"Destination key must not be null!");
        Assert.notNull((Object)sets, (String)"Source sets must not be null!");
        Assert.noNullElements((Object[])sets, (String)"Source sets must not contain null elements!");
        return this.connection.invoke().just(BinaryJedis::zinterstore, MultiKeyPipelineBase::zinterstore, destKey, sets);
    }

    @Override
    public Cursor<RedisZSetCommands.Tuple> zScan(byte[] key, ScanOptions options) {
        return this.zScan(key, 0L, options);
    }

    public Cursor<RedisZSetCommands.Tuple> zScan(byte[] key, Long cursorId, ScanOptions options) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return new KeyBoundCursor<RedisZSetCommands.Tuple>(key, cursorId.longValue(), options){

            @Override
            protected ScanIteration<RedisZSetCommands.Tuple> doScan(byte[] key, long cursorId, ScanOptions options) {
                if (JedisZSetCommands.this.isQueueing() || JedisZSetCommands.this.isPipelined()) {
                    throw new UnsupportedOperationException("'ZSCAN' cannot be called in pipeline / transaction mode.");
                }
                ScanParams params = JedisConverters.toScanParams(options);
                ScanResult result = JedisZSetCommands.this.connection.getJedis().zscan(key, JedisConverters.toBytes(cursorId), params);
                return new ScanIteration<RedisZSetCommands.Tuple>(Long.valueOf(result.getCursor()), JedisConverters.tuplesToTuples().convert(result.getResult()));
            }

            @Override
            protected void doClose() {
                JedisZSetCommands.this.connection.close();
            }
        }.open();
    }

    @Override
    public Set<byte[]> zRangeByScore(byte[] key, String min, String max) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        String keyStr = new String(key, StandardCharsets.UTF_8);
        return this.connection.invoke().fromMany(Jedis::zrangeByScore, PipelineBase::zrangeByScore, keyStr, min, max).toSet(JedisConverters::toBytes);
    }

    @Override
    public Set<byte[]> zRangeByScore(byte[] key, String min, String max, long offset, long count) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        if (offset > Integer.MAX_VALUE || count > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Offset and count must be less than Integer.MAX_VALUE for zRangeByScore in Jedis.");
        }
        String keyStr = new String(key, StandardCharsets.UTF_8);
        return this.connection.invoke().fromMany(Jedis::zrangeByScore, PipelineBase::zrangeByScore, keyStr, min, max, (int)offset, (int)count).toSet(JedisConverters::toBytes);
    }

    @Override
    public Set<byte[]> zRangeByScore(byte[] key, RedisZSetCommands.Range range, RedisZSetCommands.Limit limit) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)range, (String)"Range for ZRANGEBYSCORE must not be null!");
        Assert.notNull((Object)limit, (String)"Limit must not be null! Use Limit.unlimited() instead.");
        byte[] min = JedisConverters.boundaryToBytesForZRange(range.getMin(), JedisConverters.NEGATIVE_INFINITY_BYTES);
        byte[] max = JedisConverters.boundaryToBytesForZRange(range.getMax(), JedisConverters.POSITIVE_INFINITY_BYTES);
        if (!limit.isUnlimited()) {
            return this.connection.invoke().just(BinaryJedis::zrangeByScore, PipelineBase::zrangeByScore, key, min, max, limit.getOffset(), limit.getCount());
        }
        return this.connection.invoke().just(BinaryJedis::zrangeByScore, PipelineBase::zrangeByScore, key, min, max);
    }

    @Override
    public Set<byte[]> zRangeByLex(byte[] key, RedisZSetCommands.Range range, RedisZSetCommands.Limit limit) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)range, (String)"Range for ZRANGEBYLEX must not be null!");
        Assert.notNull((Object)limit, (String)"Limit must not be null! Use Limit.unlimited() instead.");
        byte[] min = JedisConverters.boundaryToBytesForZRangeByLex(range.getMin(), JedisConverters.MINUS_BYTES);
        byte[] max = JedisConverters.boundaryToBytesForZRangeByLex(range.getMax(), JedisConverters.PLUS_BYTES);
        if (!limit.isUnlimited()) {
            return this.connection.invoke().just(BinaryJedis::zrangeByLex, PipelineBase::zrangeByLex, key, min, max, limit.getOffset(), limit.getCount());
        }
        return this.connection.invoke().just(BinaryJedis::zrangeByLex, PipelineBase::zrangeByLex, key, min, max);
    }

    @Override
    public Set<byte[]> zRevRangeByLex(byte[] key, RedisZSetCommands.Range range, RedisZSetCommands.Limit limit) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)range, (String)"Range for ZREVRANGEBYLEX must not be null!");
        Assert.notNull((Object)limit, (String)"Limit must not be null! Use Limit.unlimited() instead.");
        byte[] min = JedisConverters.boundaryToBytesForZRangeByLex(range.getMin(), JedisConverters.MINUS_BYTES);
        byte[] max = JedisConverters.boundaryToBytesForZRangeByLex(range.getMax(), JedisConverters.PLUS_BYTES);
        if (!limit.isUnlimited()) {
            return (Set)this.connection.invoke().from(BinaryJedis::zrevrangeByLex, PipelineBase::zrevrangeByLex, key, max, min, limit.getOffset(), limit.getCount()).get(LinkedHashSet::new);
        }
        return (Set)this.connection.invoke().from(BinaryJedis::zrevrangeByLex, PipelineBase::zrevrangeByLex, key, max, min).get(LinkedHashSet::new);
    }

    private boolean isPipelined() {
        return this.connection.isPipelined();
    }

    private boolean isQueueing() {
        return this.connection.isQueueing();
    }
}

