/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.support.collections;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.SessionCallback;
import org.springframework.data.redis.support.collections.RedisStore;

abstract class CollectionUtils {
    CollectionUtils() {
    }

    static <E> Collection<E> reverse(Collection<? extends E> c) {
        Object[] reverse = new Object[c.size()];
        int index = c.size();
        for (E e : c) {
            reverse[--index] = e;
        }
        return Arrays.asList(reverse);
    }

    static Collection<String> extractKeys(Collection<? extends RedisStore> stores) {
        ArrayList<String> keys = new ArrayList<String>(stores.size());
        for (RedisStore redisStore : stores) {
            keys.add((String)redisStore.getKey());
        }
        return keys;
    }

    static <K> void rename(final K key, final K newKey, RedisOperations<K, ?> operations) {
        operations.execute(new SessionCallback<Object>(){

            @Override
            public Object execute(RedisOperations operations) throws DataAccessException {
                do {
                    operations.watch(key);
                    if (operations.hasKey(key).booleanValue()) {
                        operations.multi();
                        operations.rename(key, newKey);
                        continue;
                    }
                    operations.multi();
                } while (operations.exec() == null);
                return null;
            }
        });
    }
}

