/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.convert;

import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import org.springframework.core.convert.converter.Converter;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.RedisSystemException;
import org.springframework.data.redis.connection.FutureResult;

public class TransactionResultConverter<T>
implements Converter<List<Object>, List<Object>> {
    private final Queue<FutureResult<T>> txResults;
    private final Converter<Exception, DataAccessException> exceptionConverter;

    public TransactionResultConverter(Queue<FutureResult<T>> txResults, Converter<Exception, DataAccessException> exceptionConverter) {
        this.txResults = txResults;
        this.exceptionConverter = exceptionConverter;
    }

    public List<Object> convert(List<Object> execResults) {
        if (execResults.size() != this.txResults.size()) {
            throw new IllegalArgumentException("Incorrect number of transaction results. Expected: " + this.txResults.size() + " Actual: " + execResults.size());
        }
        ArrayList<Object> convertedResults = new ArrayList<Object>();
        for (Object result : execResults) {
            FutureResult<T> futureResult = this.txResults.remove();
            if (result instanceof Exception) {
                Exception source = (Exception)result;
                DataAccessException convertedException = (DataAccessException)((Object)this.exceptionConverter.convert((Object)source));
                throw convertedException != null ? convertedException : new RedisSystemException("Error reading future result.", source);
            }
            if (futureResult.isStatus()) continue;
            convertedResults.add(futureResult.conversionRequired() ? futureResult.convert(result) : result);
        }
        return convertedResults;
    }
}

