/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.rjc;

import org.idevlab.rjc.message.PMessageListener;
import org.idevlab.rjc.message.RedisNodeSubscriber;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.connection.rjc.RjcMessageListener;
import org.springframework.data.redis.connection.rjc.RjcUtils;
import org.springframework.data.redis.connection.util.AbstractSubscription;

class RjcSubscription
extends AbstractSubscription {
    private final RedisNodeSubscriber subscriber;

    RjcSubscription(MessageListener listener, RedisNodeSubscriber subscriber) {
        super(listener);
        this.subscriber = subscriber;
        subscriber.setMessageListener((org.idevlab.rjc.message.MessageListener)new RjcMessageListener(listener));
        subscriber.setPMessageListener((PMessageListener)new RjcMessageListener(listener));
    }

    protected void doClose() {
        this.subscriber.close();
    }

    protected void doPsubscribe(byte[] ... patterns) {
        this.subscriber.psubscribe(RjcUtils.decodeMultiple(patterns));
    }

    protected void doPUnsubscribe(boolean all, byte[] ... patterns) {
        this.subscriber.punsubscribe(RjcUtils.decodeMultiple(patterns));
    }

    protected void doSubscribe(byte[] ... channels) {
        this.subscriber.subscribe(RjcUtils.decodeMultiple(channels));
    }

    protected void doUnsubscribe(boolean all, byte[] ... channels) {
        this.subscriber.punsubscribe(RjcUtils.decodeMultiple(channels));
    }
}

