/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.r2dbc.core;

import io.r2dbc.spi.Row;
import io.r2dbc.spi.RowMetadata;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.springframework.dao.DataAccessException;
import org.springframework.data.r2dbc.convert.R2dbcConverter;
import org.springframework.data.r2dbc.core.FluentR2dbcOperations;
import org.springframework.data.r2dbc.core.ReactiveDataAccessStrategy;
import org.springframework.data.relational.core.query.Query;
import org.springframework.data.relational.core.query.Update;
import org.springframework.r2dbc.core.DatabaseClient;
import org.springframework.r2dbc.core.PreparedOperation;
import org.springframework.r2dbc.core.RowsFetchSpec;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface R2dbcEntityOperations
extends FluentR2dbcOperations {
    public DatabaseClient getDatabaseClient();

    @Deprecated
    public ReactiveDataAccessStrategy getDataAccessStrategy();

    public R2dbcConverter getConverter();

    public Mono<Long> count(Query var1, Class<?> var2) throws DataAccessException;

    public Mono<Boolean> exists(Query var1, Class<?> var2) throws DataAccessException;

    public <T> Flux<T> select(Query var1, Class<T> var2) throws DataAccessException;

    public <T> Mono<T> selectOne(Query var1, Class<T> var2) throws DataAccessException;

    public Mono<Integer> update(Query var1, Update var2, Class<?> var3) throws DataAccessException;

    public Mono<Integer> delete(Query var1, Class<?> var2) throws DataAccessException;

    public <T> RowsFetchSpec<T> query(PreparedOperation<?> var1, Class<T> var2) throws DataAccessException;

    default public <T> RowsFetchSpec<T> query(PreparedOperation<?> operation, Function<Row, T> rowMapper) throws DataAccessException {
        Assert.notNull(rowMapper, (String)"Row mapper must not be null");
        return this.query(operation, (Row row, RowMetadata rowMetadata) -> rowMapper.apply((Row)row));
    }

    public <T> RowsFetchSpec<T> query(PreparedOperation<?> var1, BiFunction<Row, RowMetadata, T> var2) throws DataAccessException;

    default public <T> RowsFetchSpec<T> query(PreparedOperation<?> operation, Class<?> entityClass, Function<Row, T> rowMapper) throws DataAccessException {
        Assert.notNull(rowMapper, (String)"Row mapper must not be null");
        return this.query(operation, entityClass, (Row row, RowMetadata rowMetadata) -> rowMapper.apply((Row)row));
    }

    public <T> RowsFetchSpec<T> query(PreparedOperation<?> var1, Class<?> var2, BiFunction<Row, RowMetadata, T> var3) throws DataAccessException;

    public <T> Mono<T> insert(T var1) throws DataAccessException;

    public <T> Mono<T> update(T var1) throws DataAccessException;

    public <T> Mono<T> delete(T var1) throws DataAccessException;
}

