/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.r2dbc.core;

import io.r2dbc.spi.ConnectionFactory;
import io.r2dbc.spi.Statement;
import java.util.function.Consumer;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.r2dbc.core.DatabaseClient;
import org.springframework.data.r2dbc.core.DefaultDatabaseClient;
import org.springframework.data.r2dbc.core.DefaultReactiveDataAccessStrategy;
import org.springframework.data.r2dbc.core.ExecuteFunction;
import org.springframework.data.r2dbc.core.ReactiveDataAccessStrategy;
import org.springframework.data.r2dbc.dialect.DialectResolver;
import org.springframework.data.r2dbc.dialect.R2dbcDialect;
import org.springframework.data.r2dbc.support.R2dbcExceptionSubclassTranslator;
import org.springframework.data.r2dbc.support.R2dbcExceptionTranslator;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

class DefaultDatabaseClientBuilder
implements DatabaseClient.Builder {
    @Nullable
    private ConnectionFactory connectionFactory;
    @Nullable
    private R2dbcExceptionTranslator exceptionTranslator;
    private ExecuteFunction executeFunction = Statement::execute;
    private ReactiveDataAccessStrategy accessStrategy;
    private boolean namedParameters = true;
    private ProjectionFactory projectionFactory;

    DefaultDatabaseClientBuilder() {
    }

    DefaultDatabaseClientBuilder(DefaultDatabaseClientBuilder other) {
        Assert.notNull((Object)other, (String)"DefaultDatabaseClientBuilder must not be null!");
        this.connectionFactory = other.connectionFactory;
        this.exceptionTranslator = other.exceptionTranslator;
        this.executeFunction = other.executeFunction;
        this.accessStrategy = other.accessStrategy;
        this.namedParameters = other.namedParameters;
        this.projectionFactory = other.projectionFactory;
    }

    @Override
    public DatabaseClient.Builder connectionFactory(ConnectionFactory factory) {
        Assert.notNull((Object)factory, (String)"ConnectionFactory must not be null!");
        this.connectionFactory = factory;
        return this;
    }

    @Override
    public DatabaseClient.Builder exceptionTranslator(R2dbcExceptionTranslator exceptionTranslator) {
        Assert.notNull((Object)exceptionTranslator, (String)"R2dbcExceptionTranslator must not be null!");
        this.exceptionTranslator = exceptionTranslator;
        return this;
    }

    @Override
    public DatabaseClient.Builder executeFunction(ExecuteFunction executeFunction) {
        Assert.notNull((Object)executeFunction, (String)"ExecuteFunction must not be null!");
        this.executeFunction = executeFunction;
        return this;
    }

    @Override
    public DatabaseClient.Builder dataAccessStrategy(ReactiveDataAccessStrategy accessStrategy) {
        Assert.notNull((Object)accessStrategy, (String)"ReactiveDataAccessStrategy must not be null!");
        this.accessStrategy = accessStrategy;
        return this;
    }

    @Override
    public DatabaseClient.Builder namedParameters(boolean enabled) {
        this.namedParameters = enabled;
        return this;
    }

    @Override
    public DatabaseClient.Builder projectionFactory(ProjectionFactory factory) {
        Assert.notNull((Object)factory, (String)"ProjectionFactory must not be null!");
        this.projectionFactory = factory;
        return this;
    }

    @Override
    public DatabaseClient build() {
        ReactiveDataAccessStrategy accessStrategy;
        R2dbcExceptionTranslator exceptionTranslator = this.exceptionTranslator;
        if (exceptionTranslator == null) {
            exceptionTranslator = new R2dbcExceptionSubclassTranslator();
        }
        if ((accessStrategy = this.accessStrategy) == null) {
            R2dbcDialect dialect = DialectResolver.getDialect(this.connectionFactory);
            accessStrategy = new DefaultReactiveDataAccessStrategy(dialect);
        }
        return new DefaultDatabaseClient(this.connectionFactory, exceptionTranslator, this.executeFunction, accessStrategy, this.namedParameters, this.projectionFactory, new DefaultDatabaseClientBuilder(this));
    }

    public DatabaseClient.Builder clone() {
        return new DefaultDatabaseClientBuilder(this);
    }

    @Override
    public DatabaseClient.Builder apply(Consumer<DatabaseClient.Builder> builderConsumer) {
        Assert.notNull(builderConsumer, (String)"BuilderConsumer must not be null");
        builderConsumer.accept(this);
        return this;
    }
}

