/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query.filter;

import java.util.Collections;
import java.util.List;
import java.util.Stack;
import org.neo4j.ogm.cypher.BooleanOperator;
import org.neo4j.ogm.cypher.ComparisonOperator;
import org.neo4j.ogm.cypher.Filter;
import org.springframework.data.neo4j.repository.query.filter.FilterBuilder;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.util.Assert;

class PropertyComparisonBuilder
extends FilterBuilder {
    PropertyComparisonBuilder(Part part, BooleanOperator booleanOperator, Class<?> entityType) {
        super(part, booleanOperator, entityType);
    }

    @Override
    public List<Filter> build(Stack<Object> params) {
        Object value = params.pop();
        Filter filter = new Filter(this.propertyName(), this.convertToComparisonOperator(this.part.getType()), value);
        filter.setOwnerEntityType(this.entityType);
        filter.setBooleanOperator(this.booleanOperator);
        filter.setNegated(this.isNegated());
        this.setNestedAttributes(this.part, filter);
        this.applyCaseInsensitivityIfShouldIgnoreCase(this.part, filter);
        return Collections.singletonList(filter);
    }

    private ComparisonOperator convertToComparisonOperator(Part.Type type) {
        switch (type) {
            case AFTER: 
            case GREATER_THAN: {
                return ComparisonOperator.GREATER_THAN;
            }
            case GREATER_THAN_EQUAL: {
                return ComparisonOperator.GREATER_THAN_EQUAL;
            }
            case BEFORE: 
            case LESS_THAN: {
                return ComparisonOperator.LESS_THAN;
            }
            case LESS_THAN_EQUAL: {
                return ComparisonOperator.LESS_THAN_EQUAL;
            }
            case REGEX: {
                return ComparisonOperator.MATCHES;
            }
            case LIKE: 
            case NOT_LIKE: {
                return ComparisonOperator.LIKE;
            }
            case STARTING_WITH: {
                return ComparisonOperator.STARTING_WITH;
            }
            case ENDING_WITH: {
                return ComparisonOperator.ENDING_WITH;
            }
            case CONTAINING: 
            case NOT_CONTAINING: {
                return ComparisonOperator.CONTAINING;
            }
            case IN: 
            case NOT_IN: {
                return ComparisonOperator.IN;
            }
            case SIMPLE_PROPERTY: {
                return ComparisonOperator.EQUALS;
            }
        }
        throw new IllegalArgumentException("No ComparisonOperator for Part.Type " + type);
    }

    private void applyCaseInsensitivityIfShouldIgnoreCase(Part part, Filter filter) {
        switch (part.shouldIgnoreCase()) {
            case ALWAYS: {
                Assert.state((boolean)this.canIgnoreCase(part), (String)("Unable to ignore case of " + part.getProperty().getLeafType().getName() + " types, the property '" + part.getProperty().getSegment() + "' must reference a String"));
                filter.ignoreCase();
                break;
            }
            case WHEN_POSSIBLE: {
                if (!this.canIgnoreCase(part)) break;
                filter.ignoreCase();
                break;
            }
        }
    }

    private boolean canIgnoreCase(Part part) {
        return part.getType() == Part.Type.SIMPLE_PROPERTY && String.class.equals((Object)part.getProperty().getLeafType());
    }
}

