/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.neo4j.ogm.cypher.BooleanOperator;
import org.springframework.data.neo4j.repository.query.TemplatedQuery;
import org.springframework.data.neo4j.repository.query.filter.FilterBuilder;
import org.springframework.data.repository.query.parser.Part;

class FilterBuildersDefinition {
    private final Class<?> entityType;
    private final Part basePart;
    private final List<FilterBuilder> filterBuilders;

    static UnstartedBuild forType(Class<?> entityType) {
        return new UnstartedBuild(entityType);
    }

    private FilterBuildersDefinition(Class<?> entityType, Part basePart) {
        this.entityType = entityType;
        this.basePart = basePart;
        this.filterBuilders = new LinkedList<FilterBuilder>();
        this.filterBuilders.add(FilterBuilder.forPartAndEntity(basePart, entityType, BooleanOperator.NONE));
    }

    TemplatedQuery buildTemplatedQuery() {
        return new TemplatedQuery(Collections.unmodifiableList(this.filterBuilders));
    }

    Part getBasePart() {
        return this.basePart;
    }

    FilterBuildersDefinition and(Part part) {
        this.filterBuilders.add(FilterBuilder.forPartAndEntity(part, this.entityType, BooleanOperator.AND));
        return this;
    }

    FilterBuildersDefinition or(Part part) {
        this.filterBuilders.add(FilterBuilder.forPartAndEntity(part, this.entityType, BooleanOperator.OR));
        return this;
    }

    static class UnstartedBuild {
        private final Class<?> entityType;

        UnstartedBuild(Class<?> entityType) {
            this.entityType = entityType;
        }

        FilterBuildersDefinition startWith(Part firstPart) {
            return new FilterBuildersDefinition(this.entityType, firstPart);
        }
    }
}

