/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.keyvalue.repository.support;

import org.springframework.core.convert.converter.Converter;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.PreferredConstructor;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.model.EntityInstantiator;
import org.springframework.data.mapping.model.EntityInstantiators;
import org.springframework.data.mapping.model.ParameterValueProvider;
import org.springframework.util.Assert;

class DtoInstantiatingConverter
implements Converter<Object, Object> {
    private final Class<?> targetType;
    private final MappingContext<? extends PersistentEntity<?, ?>, ? extends PersistentProperty<?>> context;
    private final EntityInstantiator instantiator;

    public DtoInstantiatingConverter(Class<?> dtoType, MappingContext<? extends PersistentEntity<?, ?>, ? extends PersistentProperty<?>> context, EntityInstantiators entityInstantiators) {
        Assert.notNull(dtoType, (String)"DTO type must not be null!");
        Assert.notNull(context, (String)"MappingContext must not be null!");
        Assert.notNull((Object)entityInstantiators, (String)"EntityInstantiators must not be null!");
        this.targetType = dtoType;
        this.context = context;
        this.instantiator = entityInstantiators.getInstantiatorFor(context.getRequiredPersistentEntity(dtoType));
    }

    public Object convert(Object source) {
        if (this.targetType.isInterface()) {
            return source;
        }
        final PersistentEntity sourceEntity = this.context.getRequiredPersistentEntity(source.getClass());
        final PersistentPropertyAccessor sourceAccessor = sourceEntity.getPropertyAccessor(source);
        PersistentEntity targetEntity = this.context.getRequiredPersistentEntity(this.targetType);
        PreferredConstructor constructor = targetEntity.getPersistenceConstructor();
        Object dto = this.instantiator.createInstance(targetEntity, new ParameterValueProvider(){

            public Object getParameterValue(PreferredConstructor.Parameter parameter) {
                return sourceAccessor.getProperty(sourceEntity.getPersistentProperty(parameter.getName()));
            }
        });
        PersistentPropertyAccessor dtoAccessor = targetEntity.getPropertyAccessor(dto);
        targetEntity.doWithProperties(property -> {
            if (constructor.isConstructorParameter(property)) {
                return;
            }
            dtoAccessor.setProperty(property, sourceAccessor.getProperty(sourceEntity.getPersistentProperty(property.getName())));
        });
        return dto;
    }
}

