/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.keyvalue.core.mapping.context;

import java.util.Collections;
import org.springframework.data.keyvalue.core.mapping.BasicKeyValuePersistentEntity;
import org.springframework.data.keyvalue.core.mapping.KeySpaceResolver;
import org.springframework.data.keyvalue.core.mapping.KeyValuePersistentEntity;
import org.springframework.data.keyvalue.core.mapping.KeyValuePersistentProperty;
import org.springframework.data.mapping.context.AbstractMappingContext;
import org.springframework.data.mapping.model.Property;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.Nullable;

public class KeyValueMappingContext<E extends KeyValuePersistentEntity<?, P>, P extends KeyValuePersistentProperty<P>>
extends AbstractMappingContext<E, P> {
    @Nullable
    private KeySpaceResolver fallbackKeySpaceResolver;

    public KeyValueMappingContext() {
        this.setSimpleTypeHolder(new KeyValueSimpleTypeHolder());
    }

    public void setFallbackKeySpaceResolver(KeySpaceResolver fallbackKeySpaceResolver) {
        this.fallbackKeySpaceResolver = fallbackKeySpaceResolver;
    }

    protected <T> E createPersistentEntity(TypeInformation<T> typeInformation) {
        return (E)new BasicKeyValuePersistentEntity(typeInformation, this.fallbackKeySpaceResolver);
    }

    protected P createPersistentProperty(Property property, E owner, SimpleTypeHolder simpleTypeHolder) {
        return (P)((Object)new KeyValuePersistentProperty(property, owner, simpleTypeHolder));
    }

    private static class KeyValueSimpleTypeHolder
    extends SimpleTypeHolder {
        public KeyValueSimpleTypeHolder() {
            super(Collections.emptySet(), true);
        }

        public boolean isSimpleType(Class<?> type) {
            if (type.getName().startsWith("java.math.") || type.getName().startsWith("java.util.")) {
                return true;
            }
            return super.isSimpleType(type);
        }
    }
}

