/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.support;

import jakarta.persistence.EntityManager;
import jakarta.persistence.Query;
import jakarta.persistence.TypedQuery;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.ScrollPosition;
import org.springframework.data.domain.Sort;
import org.springframework.data.domain.Window;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.repository.query.ScrollDelegate;
import org.springframework.data.jpa.repository.support.EntityGraphFactory;
import org.springframework.data.jpa.repository.support.FluentQuerySupport;
import org.springframework.data.jpa.repository.support.JpaEntityInformation;
import org.springframework.data.jpa.support.PageableUtils;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.query.FluentQuery;
import org.springframework.data.support.PageableExecutionUtils;
import org.springframework.util.Assert;

class FetchableFluentQueryBySpecification<S, R>
extends FluentQuerySupport<S, R>
implements FluentQuery.FetchableFluentQuery<R> {
    private final Specification<S> spec;
    private final Function<Sort, TypedQuery<S>> finder;
    private final SpecificationScrollDelegate<S> scroll;
    private final Function<Specification<S>, Long> countOperation;
    private final Function<Specification<S>, Boolean> existsOperation;
    private final EntityManager entityManager;

    FetchableFluentQueryBySpecification(Specification<S> spec, Class<S> entityType, Function<Sort, TypedQuery<S>> finder, SpecificationScrollDelegate<S> scrollDelegate, Function<Specification<S>, Long> countOperation, Function<Specification<S>, Boolean> existsOperation, EntityManager entityManager, ProjectionFactory projectionFactory) {
        this(spec, entityType, entityType, Sort.unsorted(), 0, Collections.emptySet(), finder, scrollDelegate, countOperation, existsOperation, entityManager, projectionFactory);
    }

    private FetchableFluentQueryBySpecification(Specification<S> spec, Class<S> entityType, Class<R> resultType, Sort sort, int limit, Collection<String> properties, Function<Sort, TypedQuery<S>> finder, SpecificationScrollDelegate<S> scrollDelegate, Function<Specification<S>, Long> countOperation, Function<Specification<S>, Boolean> existsOperation, EntityManager entityManager, ProjectionFactory projectionFactory) {
        super(resultType, sort, limit, properties, entityType, projectionFactory);
        this.spec = spec;
        this.finder = finder;
        this.scroll = scrollDelegate;
        this.countOperation = countOperation;
        this.existsOperation = existsOperation;
        this.entityManager = entityManager;
    }

    public FluentQuery.FetchableFluentQuery<R> sortBy(Sort sort) {
        Assert.notNull((Object)sort, (String)"Sort must not be null");
        return new FetchableFluentQueryBySpecification<S, R>(this.spec, this.entityType, this.resultType, this.sort.and(sort), this.limit, this.properties, this.finder, this.scroll, this.countOperation, this.existsOperation, this.entityManager, this.projectionFactory);
    }

    public FluentQuery.FetchableFluentQuery<R> limit(int limit) {
        Assert.isTrue((limit >= 0 ? 1 : 0) != 0, (String)"Limit must not be negative");
        return new FetchableFluentQueryBySpecification<S, R>(this.spec, this.entityType, this.resultType, this.sort, limit, this.properties, this.finder, this.scroll, this.countOperation, this.existsOperation, this.entityManager, this.projectionFactory);
    }

    public <NR> FluentQuery.FetchableFluentQuery<NR> as(Class<NR> resultType) {
        Assert.notNull(resultType, (String)"Projection target type must not be null");
        if (!resultType.isInterface()) {
            throw new UnsupportedOperationException("Class-based DTOs are not yet supported.");
        }
        return new FetchableFluentQueryBySpecification<S, NR>(this.spec, this.entityType, resultType, this.sort, this.limit, this.properties, this.finder, this.scroll, this.countOperation, this.existsOperation, this.entityManager, this.projectionFactory);
    }

    public FluentQuery.FetchableFluentQuery<R> project(Collection<String> properties) {
        return new FetchableFluentQueryBySpecification<S, R>(this.spec, this.entityType, this.resultType, this.sort, this.limit, properties, this.finder, this.scroll, this.countOperation, this.existsOperation, this.entityManager, this.projectionFactory);
    }

    public R oneValue() {
        List results = this.createSortedAndProjectedQuery().setMaxResults(2).getResultList();
        if (results.size() > 1) {
            throw new IncorrectResultSizeDataAccessException(1);
        }
        return results.isEmpty() ? null : (R)this.getConversionFunction().apply(results.get(0));
    }

    public R firstValue() {
        List results = this.createSortedAndProjectedQuery().setMaxResults(1).getResultList();
        return results.isEmpty() ? null : (R)this.getConversionFunction().apply(results.get(0));
    }

    public List<R> all() {
        return this.convert(this.createSortedAndProjectedQuery().getResultList());
    }

    public Window<R> scroll(ScrollPosition scrollPosition) {
        Assert.notNull((Object)scrollPosition, (String)"ScrollPosition must not be null");
        return this.scroll.scroll(this.sort, this.limit, scrollPosition).map(this.getConversionFunction());
    }

    public Page<R> page(Pageable pageable) {
        return pageable.isUnpaged() ? new PageImpl(this.all()) : this.readPage(pageable);
    }

    public Stream<R> stream() {
        return this.createSortedAndProjectedQuery().getResultStream().map(this.getConversionFunction());
    }

    public long count() {
        return this.countOperation.apply(this.spec);
    }

    public boolean exists() {
        return this.existsOperation.apply(this.spec);
    }

    private TypedQuery<S> createSortedAndProjectedQuery() {
        TypedQuery<S> query = this.finder.apply(this.sort);
        if (!this.properties.isEmpty()) {
            query.setHint("jakarta.persistence.fetchgraph", EntityGraphFactory.create(this.entityManager, this.entityType, this.properties));
        }
        if (this.limit != 0) {
            query.setMaxResults(this.limit);
        }
        return query;
    }

    private Page<R> readPage(Pageable pageable) {
        TypedQuery<S> pagedQuery = this.createSortedAndProjectedQuery();
        if (pageable.isPaged()) {
            pagedQuery.setFirstResult(PageableUtils.getOffsetAsInteger(pageable));
            pagedQuery.setMaxResults(pageable.getPageSize());
        }
        List<R> paginatedResults = this.convert(pagedQuery.getResultList());
        return PageableExecutionUtils.getPage(paginatedResults, (Pageable)pageable, () -> this.countOperation.apply(this.spec));
    }

    private List<R> convert(List<S> resultList) {
        Function<Object, R> conversionFunction = this.getConversionFunction();
        ArrayList<R> mapped = new ArrayList<R>(resultList.size());
        for (S s : resultList) {
            mapped.add(conversionFunction.apply(s));
        }
        return mapped;
    }

    private Function<Object, R> getConversionFunction() {
        return this.getConversionFunction(this.entityType, this.resultType);
    }

    static class SpecificationScrollDelegate<T>
    extends ScrollDelegate<T> {
        private final FluentQuerySupport.ScrollQueryFactory scrollFunction;

        SpecificationScrollDelegate(FluentQuerySupport.ScrollQueryFactory scrollQueryFactory, JpaEntityInformation<T, ?> entity) {
            super(entity);
            this.scrollFunction = scrollQueryFactory;
        }

        public Window<T> scroll(Sort sort, int limit, ScrollPosition scrollPosition) {
            Query query = this.scrollFunction.createQuery(sort, scrollPosition);
            if (limit > 0) {
                query = query.setMaxResults(limit);
            }
            return this.scroll(query, sort, scrollPosition);
        }
    }
}

