/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import jakarta.persistence.AttributeNode;
import jakarta.persistence.EntityGraph;
import jakarta.persistence.EntityManager;
import jakarta.persistence.Subgraph;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.data.jpa.repository.query.JpaEntityGraph;
import org.springframework.data.jpa.repository.support.MutableQueryHints;
import org.springframework.data.jpa.repository.support.QueryHints;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class Jpa21Utils {
    private Jpa21Utils() {
    }

    public static QueryHints getFetchGraphHint(EntityManager em, JpaEntityGraph entityGraph, Class<?> entityType) {
        MutableQueryHints result = new MutableQueryHints();
        EntityGraph<?> graph = Jpa21Utils.tryGetFetchGraph(em, entityGraph, entityType);
        result.add(entityGraph.getType().getKey(), graph);
        return result;
    }

    private static EntityGraph<?> tryGetFetchGraph(EntityManager em, JpaEntityGraph jpaEntityGraph, Class<?> entityType) {
        Assert.notNull((Object)em, (String)"EntityManager must not be null");
        Assert.notNull((Object)jpaEntityGraph, (String)"EntityGraph must not be null");
        Assert.notNull(entityType, (String)"EntityType must not be null");
        if (StringUtils.hasText((String)jpaEntityGraph.getName())) {
            try {
                return em.getEntityGraph(jpaEntityGraph.getName());
            }
            catch (Exception exception) {}
        }
        return Jpa21Utils.createDynamicEntityGraph(em, jpaEntityGraph, entityType);
    }

    private static EntityGraph<?> createDynamicEntityGraph(EntityManager em, JpaEntityGraph jpaEntityGraph, Class<?> entityType) {
        Assert.notNull((Object)em, (String)"EntityManager must not be null");
        Assert.notNull((Object)jpaEntityGraph, (String)"JpaEntityGraph must not be null");
        Assert.notNull(entityType, (String)"Entity type must not be null");
        EntityGraph entityGraph = em.createEntityGraph(entityType);
        Jpa21Utils.configureFetchGraphFrom(jpaEntityGraph, entityGraph);
        return entityGraph;
    }

    static void configureFetchGraphFrom(JpaEntityGraph jpaEntityGraph, EntityGraph<?> entityGraph) {
        ArrayList<String> attributePaths = new ArrayList<String>(jpaEntityGraph.getAttributePaths());
        Collections.sort(attributePaths);
        for (String path : attributePaths) {
            String[] pathComponents = StringUtils.delimitedListToStringArray((String)path, (String)".");
            Jpa21Utils.createGraph(pathComponents, 0, entityGraph, null);
        }
    }

    private static void createGraph(String[] pathComponents, int offset, EntityGraph<?> root, @Nullable Subgraph<?> parent) {
        String attributeName = pathComponents[offset];
        if (pathComponents.length - 1 == offset) {
            if (parent == null && !Jpa21Utils.exists(attributeName, root.getAttributeNodes())) {
                root.addAttributeNodes(new String[]{attributeName});
            } else if (parent != null && !Jpa21Utils.exists(attributeName, parent.getAttributeNodes())) {
                parent.addAttributeNodes(new String[]{attributeName});
            }
            return;
        }
        AttributeNode<?> node = Jpa21Utils.findAttributeNode(attributeName, root, parent);
        if (node != null) {
            Subgraph subgraph = Jpa21Utils.getSubgraph(node);
            if (subgraph == null) {
                subgraph = parent != null ? parent.addSubgraph(attributeName) : root.addSubgraph(attributeName);
            }
            Jpa21Utils.createGraph(pathComponents, offset + 1, root, subgraph);
            return;
        }
        if (parent == null) {
            Jpa21Utils.createGraph(pathComponents, offset + 1, root, root.addSubgraph(attributeName));
        } else {
            Jpa21Utils.createGraph(pathComponents, offset + 1, root, parent.addSubgraph(attributeName));
        }
    }

    private static boolean exists(String attributeNodeName, List<AttributeNode<?>> nodes) {
        return Jpa21Utils.findAttributeNode(attributeNodeName, nodes) != null;
    }

    @Nullable
    private static AttributeNode<?> findAttributeNode(String attributeNodeName, EntityGraph<?> entityGraph, @Nullable Subgraph<?> parent) {
        return Jpa21Utils.findAttributeNode(attributeNodeName, parent != null ? parent.getAttributeNodes() : entityGraph.getAttributeNodes());
    }

    @Nullable
    private static AttributeNode<?> findAttributeNode(String attributeNodeName, List<AttributeNode<?>> nodes) {
        for (AttributeNode<?> node : nodes) {
            if (!ObjectUtils.nullSafeEquals((Object)node.getAttributeName(), (Object)attributeNodeName)) continue;
            return node;
        }
        return null;
    }

    @Nullable
    private static Subgraph<?> getSubgraph(AttributeNode<?> node) {
        return node.getSubgraphs().isEmpty() ? null : (Subgraph)node.getSubgraphs().values().iterator().next();
    }
}

