/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.config;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import javax.persistence.Entity;
import javax.persistence.MappedSuperclass;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.io.ResourceLoader;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.config.InspectionClassLoader;
import org.springframework.data.jpa.repository.config.JpaMetamodelMappingContextFactoryBean;
import org.springframework.data.jpa.repository.support.DefaultJpaContext;
import org.springframework.data.jpa.repository.support.EntityManagerBeanDefinitionRegistrarPostProcessor;
import org.springframework.data.jpa.repository.support.JpaRepositoryFactoryBean;
import org.springframework.data.repository.config.AnnotationRepositoryConfigurationSource;
import org.springframework.data.repository.config.RepositoryConfigurationExtensionSupport;
import org.springframework.data.repository.config.RepositoryConfigurationSource;
import org.springframework.data.repository.config.XmlRepositoryConfigurationSource;
import org.springframework.lang.Nullable;
import org.springframework.orm.jpa.support.PersistenceAnnotationBeanPostProcessor;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class JpaRepositoryConfigExtension
extends RepositoryConfigurationExtensionSupport {
    private static final Class<?> PAB_POST_PROCESSOR = PersistenceAnnotationBeanPostProcessor.class;
    private static final String DEFAULT_TRANSACTION_MANAGER_BEAN_NAME = "transactionManager";
    private static final String ENABLE_DEFAULT_TRANSACTIONS_ATTRIBUTE = "enableDefaultTransactions";
    private static final String JPA_METAMODEL_CACHE_CLEANUP_CLASSNAME = "org.springframework.data.jpa.util.JpaMetamodelCacheCleanup";

    public String getModuleName() {
        return "JPA";
    }

    public String getRepositoryFactoryBeanClassName() {
        return JpaRepositoryFactoryBean.class.getName();
    }

    protected String getModulePrefix() {
        return this.getModuleName().toLowerCase(Locale.US);
    }

    protected Collection<Class<? extends Annotation>> getIdentifyingAnnotations() {
        return Arrays.asList(Entity.class, MappedSuperclass.class);
    }

    protected Collection<Class<?>> getIdentifyingTypes() {
        return Collections.singleton(JpaRepository.class);
    }

    public void postProcess(BeanDefinitionBuilder builder, RepositoryConfigurationSource source) {
        Optional transactionManagerRef = source.getAttribute("transactionManagerRef");
        builder.addPropertyValue(DEFAULT_TRANSACTION_MANAGER_BEAN_NAME, (Object)transactionManagerRef.orElse(DEFAULT_TRANSACTION_MANAGER_BEAN_NAME));
        builder.addPropertyValue("entityManager", (Object)JpaRepositoryConfigExtension.getEntityManagerBeanDefinitionFor(source, source.getSource()));
        builder.addPropertyReference("mappingContext", "jpaMappingContext");
    }

    public void postProcess(BeanDefinitionBuilder builder, AnnotationRepositoryConfigurationSource config) {
        AnnotationAttributes attributes = config.getAttributes();
        builder.addPropertyValue(ENABLE_DEFAULT_TRANSACTIONS_ATTRIBUTE, (Object)attributes.getBoolean(ENABLE_DEFAULT_TRANSACTIONS_ATTRIBUTE));
    }

    public void postProcess(BeanDefinitionBuilder builder, XmlRepositoryConfigurationSource config) {
        Optional enableDefaultTransactions = config.getAttribute(ENABLE_DEFAULT_TRANSACTIONS_ATTRIBUTE);
        if (enableDefaultTransactions.isPresent() && StringUtils.hasText((String)((String)enableDefaultTransactions.get()))) {
            builder.addPropertyValue(ENABLE_DEFAULT_TRANSACTIONS_ATTRIBUTE, enableDefaultTransactions.get());
        }
    }

    public void registerBeansForRoot(BeanDefinitionRegistry registry, RepositoryConfigurationSource config) {
        super.registerBeansForRoot(registry, config);
        Object source = config.getSource();
        JpaRepositoryConfigExtension.registerLazyIfNotAlreadyRegistered(() -> new RootBeanDefinition(EntityManagerBeanDefinitionRegistrarPostProcessor.class), (BeanDefinitionRegistry)registry, (String)"emBeanDefinitionRegistrarPostProcessor", (Object)source);
        JpaRepositoryConfigExtension.registerLazyIfNotAlreadyRegistered(() -> new RootBeanDefinition(JpaMetamodelMappingContextFactoryBean.class), (BeanDefinitionRegistry)registry, (String)"jpaMappingContext", (Object)source);
        JpaRepositoryConfigExtension.registerLazyIfNotAlreadyRegistered(() -> new RootBeanDefinition(PAB_POST_PROCESSOR), (BeanDefinitionRegistry)registry, (String)"org.springframework.context.annotation.internalPersistenceAnnotationProcessor", (Object)source);
        JpaRepositoryConfigExtension.registerLazyIfNotAlreadyRegistered(() -> {
            RootBeanDefinition contextDefinition = new RootBeanDefinition(DefaultJpaContext.class);
            contextDefinition.setAutowireMode(3);
            return contextDefinition;
        }, (BeanDefinitionRegistry)registry, (String)"jpaContext", (Object)source);
        JpaRepositoryConfigExtension.registerIfNotAlreadyRegistered(() -> new RootBeanDefinition(JPA_METAMODEL_CACHE_CLEANUP_CLASSNAME), (BeanDefinitionRegistry)registry, (String)JPA_METAMODEL_CACHE_CLEANUP_CLASSNAME, (Object)source);
    }

    protected ClassLoader getConfigurationInspectionClassLoader(ResourceLoader loader) {
        ClassLoader classLoader = loader.getClassLoader();
        return classLoader != null && LazyJvmAgent.isActive(loader.getClassLoader()) ? new InspectionClassLoader(loader.getClassLoader()) : loader.getClassLoader();
    }

    private static AbstractBeanDefinition getEntityManagerBeanDefinitionFor(RepositoryConfigurationSource config, @Nullable Object source) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition((String)"org.springframework.orm.jpa.SharedEntityManagerCreator");
        builder.setFactoryMethod("createSharedEntityManager");
        builder.addConstructorArgReference(JpaRepositoryConfigExtension.getEntityManagerBeanRef(config));
        AbstractBeanDefinition bean = builder.getRawBeanDefinition();
        bean.setSource(source);
        return bean;
    }

    private static String getEntityManagerBeanRef(RepositoryConfigurationSource config) {
        Optional entityManagerFactoryRef = config.getAttribute("entityManagerFactoryRef");
        return entityManagerFactoryRef.orElse("entityManagerFactory");
    }

    static final class LazyJvmAgent {
        private static final Set<String> AGENT_CLASSES;

        static boolean isActive(@Nullable ClassLoader classLoader) {
            return AGENT_CLASSES.stream().anyMatch(agentClass -> ClassUtils.isPresent((String)agentClass, (ClassLoader)classLoader));
        }

        private LazyJvmAgent() {
            throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
        }

        static {
            LinkedHashSet<String> agentClasses = new LinkedHashSet<String>();
            agentClasses.add("org.springframework.instrument.InstrumentationSavingAgent");
            agentClasses.add("org.eclipse.persistence.internal.jpa.deployment.JavaSECMPInitializerAgent");
            AGENT_CLASSES = Collections.unmodifiableSet(agentClasses);
        }
    }
}

