/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.projection;

import java.beans.PropertyDescriptor;
import java.util.Collection;
import java.util.Map;
import org.springframework.data.projection.ProjectionInformation;
import org.springframework.data.projection.SpelAwareProxyProjectionFactory;

public class CollectionAwareProjectionFactory
extends SpelAwareProxyProjectionFactory {
    protected ProjectionInformation createProjectionInformation(Class<?> projectionType) {
        return new CollectionAwareProjectionInformation(projectionType);
    }

    private static class CollectionAwareProjectionInformation
    extends SpelAwareProxyProjectionFactory.SpelAwareProjectionInformation {
        CollectionAwareProjectionInformation(Class<?> projectionType) {
            super(projectionType);
        }

        protected boolean isInputProperty(PropertyDescriptor descriptor) {
            if (!super.isInputProperty(descriptor)) {
                return false;
            }
            return !Collection.class.isAssignableFrom(descriptor.getPropertyType()) && !Map.class.isAssignableFrom(descriptor.getPropertyType());
        }
    }
}

