/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.support;

import org.springframework.data.jpa.repository.query.EscapeCharacter;
import org.springframework.data.repository.query.spi.EvaluationContextExtensionSupport;

public class JpaEvaluationContextExtension
extends EvaluationContextExtensionSupport {
    private final JpaRootObject root;

    public JpaEvaluationContextExtension(char escapeCharacter) {
        this.root = JpaRootObject.of(EscapeCharacter.of(escapeCharacter));
    }

    public String getExtensionId() {
        return "jpa";
    }

    public Object getRootObject() {
        return this.root;
    }

    public static class JpaRootObject {
        private final EscapeCharacter character;

        public String escape(String source) {
            return this.character.escape(source);
        }

        public char escapeCharacter() {
            return this.character.getEscapeCharacter();
        }

        private JpaRootObject(EscapeCharacter character) {
            this.character = character;
        }

        public static JpaRootObject of(EscapeCharacter character) {
            return new JpaRootObject(character);
        }
    }
}

