/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.persistence.NamedStoredProcedureQueries;
import javax.persistence.NamedStoredProcedureQuery;
import javax.persistence.StoredProcedureParameter;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.data.jpa.repository.query.JpaEntityMetadata;
import org.springframework.data.jpa.repository.query.Procedure;
import org.springframework.data.jpa.repository.query.StoredProcedureAttributes;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

enum StoredProcedureAttributeSource {
    INSTANCE;


    public StoredProcedureAttributes createFrom(Method method, JpaEntityMetadata<?> entityMetadata) {
        Assert.notNull((Object)method, (String)"Method must not be null!");
        Assert.notNull(entityMetadata, (String)"EntityMetadata must not be null!");
        Procedure procedure = (Procedure)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, Procedure.class);
        Assert.notNull((Object)procedure, (String)"Method must have an @Procedure annotation!");
        NamedStoredProcedureQuery namedStoredProc = this.tryFindAnnotatedNamedStoredProcedureQuery(method, entityMetadata, procedure);
        if (namedStoredProc != null) {
            return this.newProcedureAttributesFrom(method, namedStoredProc, procedure);
        }
        String procedureName = this.deriveProcedureNameFrom(method, procedure);
        if (StringUtils.isEmpty((Object)procedureName)) {
            throw new IllegalArgumentException("Could not determine name of procedure for @Procedure annotated method: " + method);
        }
        return new StoredProcedureAttributes(procedureName, procedure.outputParameterName(), method.getReturnType(), false);
    }

    private String deriveProcedureNameFrom(Method method, Procedure procedure) {
        if (StringUtils.hasText((String)procedure.value())) {
            return procedure.value();
        }
        String procedureName = procedure.procedureName();
        return StringUtils.hasText((String)procedureName) ? procedureName : method.getName();
    }

    private StoredProcedureAttributes newProcedureAttributesFrom(Method method, NamedStoredProcedureQuery namedStoredProc, Procedure procedure) {
        String outputParameterName = null;
        Class outputParameterType = null;
        if (!procedure.outputParameterName().isEmpty()) {
            outputParameterName = procedure.outputParameterName();
        } else {
            List<StoredProcedureParameter> outputParameters = this.extractOutputParametersFrom(namedStoredProc);
            if (outputParameters.size() != 1 && !Void.TYPE.equals(method.getReturnType())) {
                throw new IllegalStateException(String.format("Could not create ProcedureAttributes from %s. We currently support exactly one output parameter!", method));
            }
            if (!outputParameters.isEmpty()) {
                StoredProcedureParameter outputParameter = outputParameters.get(0);
                outputParameterName = outputParameter.name();
                outputParameterType = outputParameter.type();
            }
        }
        if (outputParameterType == null || Object.class.equals(outputParameterType) || Void.TYPE.equals(outputParameterType)) {
            outputParameterType = method.getReturnType();
        }
        return new StoredProcedureAttributes(namedStoredProc.name(), outputParameterName, outputParameterType, true);
    }

    private List<StoredProcedureParameter> extractOutputParametersFrom(NamedStoredProcedureQuery namedStoredProc) {
        ArrayList<StoredProcedureParameter> outputParameters = new ArrayList<StoredProcedureParameter>();
        block3: for (StoredProcedureParameter param : namedStoredProc.parameters()) {
            switch (param.mode()) {
                case OUT: 
                case INOUT: 
                case REF_CURSOR: {
                    outputParameters.add(param);
                    continue block3;
                }
                default: {
                    continue block3;
                }
            }
        }
        return outputParameters;
    }

    private NamedStoredProcedureQuery tryFindAnnotatedNamedStoredProcedureQuery(Method method, JpaEntityMetadata<?> entityMetadata, Procedure procedure) {
        Assert.notNull((Object)method, (String)"Method must not be null!");
        Assert.notNull(entityMetadata, (String)"EntityMetadata must not be null!");
        Assert.notNull((Object)procedure, (String)"Procedure must not be null!");
        Class entityType = entityMetadata.getJavaType();
        List<NamedStoredProcedureQuery> queries = this.collectNamedStoredProcedureQueriesFrom(entityType);
        if (queries.isEmpty()) {
            return null;
        }
        String namedProcedureName = this.derivedNamedProcedureNameFrom(method, entityMetadata, procedure);
        for (NamedStoredProcedureQuery query : queries) {
            if (!query.name().equals(namedProcedureName)) continue;
            return query;
        }
        return null;
    }

    private String derivedNamedProcedureNameFrom(Method method, JpaEntityMetadata<?> entityMetadata, Procedure procedure) {
        return StringUtils.hasText((String)procedure.name()) ? procedure.name() : entityMetadata.getEntityName() + "." + method.getName();
    }

    private List<NamedStoredProcedureQuery> collectNamedStoredProcedureQueriesFrom(Class<?> entityType) {
        NamedStoredProcedureQuery namedQueryAnnotation;
        ArrayList<NamedStoredProcedureQuery> queries = new ArrayList<NamedStoredProcedureQuery>();
        NamedStoredProcedureQueries namedQueriesAnnotation = (NamedStoredProcedureQueries)AnnotatedElementUtils.findMergedAnnotation(entityType, NamedStoredProcedureQueries.class);
        if (namedQueriesAnnotation != null) {
            queries.addAll(Arrays.asList(namedQueriesAnnotation.value()));
        }
        if ((namedQueryAnnotation = (NamedStoredProcedureQuery)AnnotatedElementUtils.findMergedAnnotation(entityType, NamedStoredProcedureQuery.class)) != null) {
            queries.add(namedQueryAnnotation);
        }
        return queries;
    }
}

