/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.Tuple;
import org.springframework.data.jpa.provider.HibernateUtils;
import org.springframework.data.jpa.repository.query.AbstractStringBasedJpaQuery;
import org.springframework.data.jpa.repository.query.InvalidJpaQueryMethodException;
import org.springframework.data.jpa.repository.query.JpaParameters;
import org.springframework.data.jpa.repository.query.JpaQueryMethod;
import org.springframework.data.repository.query.EvaluationContextProvider;
import org.springframework.data.repository.query.ReturnedType;
import org.springframework.expression.spel.standard.SpelExpressionParser;

final class NativeJpaQuery
extends AbstractStringBasedJpaQuery {
    public NativeJpaQuery(JpaQueryMethod method, EntityManager em, String queryString, EvaluationContextProvider evaluationContextProvider, SpelExpressionParser parser) {
        super(method, em, queryString, evaluationContextProvider, parser);
        boolean containsPageableOrSortInQueryExpression;
        JpaParameters parameters = method.getParameters();
        boolean hasPagingOrSortingParameter = parameters.hasPageableParameter() || parameters.hasSortParameter();
        boolean bl = containsPageableOrSortInQueryExpression = queryString.contains("#pageable") || queryString.contains("#sort");
        if (hasPagingOrSortingParameter && !containsPageableOrSortInQueryExpression) {
            throw new InvalidJpaQueryMethodException("Cannot use native queries with dynamic sorting and/or pagination in method " + (Object)((Object)method));
        }
    }

    @Override
    protected Query createJpaQuery(String queryString, ReturnedType returnedType) {
        EntityManager em = this.getEntityManager();
        Class<?> type = this.getTypeToQueryFor(returnedType);
        return type == null ? em.createNativeQuery(queryString) : em.createNativeQuery(queryString, type);
    }

    private Class<?> getTypeToQueryFor(ReturnedType returnedType) {
        Class<Tuple> result;
        Class<Tuple> clazz = result = this.getQueryMethod().isQueryForEntity() ? returnedType.getDomainType() : null;
        if (this.getQuery().hasConstructorExpression() || this.getQuery().isDefaultProjection()) {
            return result;
        }
        return returnedType.isProjecting() && !this.getMetamodel().isJpaManaged(returnedType.getReturnedType()) && HibernateUtils.supportsTuplesForNativeQueries() ? Tuple.class : result;
    }
}

