/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.pig;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;

public class PigScript {
    private Resource resource;
    private Map<String, String> arguments;

    public PigScript(Resource resource) {
        this(resource, (Properties)null);
    }

    public PigScript(Resource resource, Properties args) {
        Assert.notNull((Object)resource, (String)"a valid resource is required");
        this.resource = resource;
        if (args != null) {
            LinkedHashMap<String, String> arguments = new LinkedHashMap<String, String>();
            for (String key : args.stringPropertyNames()) {
                arguments.put(key, args.getProperty(key));
            }
            this.arguments = arguments;
        }
    }

    public PigScript(Resource resource, Map<?, ?> args) {
        Assert.notNull((Object)resource, (String)"a valid resource is required");
        this.resource = resource;
        if (args != null) {
            this.arguments = new LinkedHashMap<String, String>();
            for (Map.Entry<?, ?> entry : args.entrySet()) {
                this.arguments.put(entry.getKey().toString(), entry.getValue().toString());
            }
        }
    }

    public Resource getResource() {
        return this.resource;
    }

    public Map<String, String> getArguments() {
        return this.arguments;
    }

    public String toString() {
        return this.resource.getDescription();
    }
}

