/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.hive;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.jdbc.core.ConnectionCallback;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceUtils;

public class HiveClient {
    private JdbcTemplate jdbcTemplate;

    public HiveClient(DataSource dataSource) {
        this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

    public Connection getConnection() {
        return DataSourceUtils.getConnection((DataSource)this.jdbcTemplate.getDataSource());
    }

    public String executeAndfetchOne(String command) {
        List<String> results = this.execute(command);
        if (results.size() < 1) {
            throw new IncorrectResultSizeDataAccessException(1);
        }
        return results.get(0);
    }

    public List<String> execute(final String command) {
        return (List)this.jdbcTemplate.execute((ConnectionCallback)new ConnectionCallback<List<String>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public List<String> doInConnection(Connection con) throws SQLException, DataAccessException {
                ArrayList<String> results = new ArrayList<String>();
                Statement stmt = con.createStatement();
                ResultSet rs = null;
                int i = 0;
                try {
                    boolean retRs = stmt.execute(command);
                    if (retRs) {
                        rs = stmt.getResultSet();
                        while (rs.next()) {
                            results.add(rs.getString(1));
                            ++i;
                        }
                    }
                }
                finally {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Exception exception) {}
                    }
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Exception exception) {}
                    }
                }
                return results;
            }
        });
    }

    JdbcOperations getJdbcOperations() {
        return this.jdbcTemplate;
    }

    public void shutdown() throws SQLException {
        this.jdbcTemplate.getDataSource().getConnection().close();
    }
}

